<?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php
App::setLocale(Auth::user()->lang);
?>

<link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/vendors/css/tables/datatable/dataTables.bootstrap5.min.css">

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="card-body">
            <button type="button" class="btn btn-primary float-end" data-bs-toggle="modal" data-bs-target="#addNew"><?php echo e(__('Add new package')); ?></button>
        </div>
        <div class="content-header row">
            <h4><?php echo e(__('Packages list')); ?><span class="badge rounded-pill badge-light-secondary"><?php echo e(DB::table('packages')->count()); ?></span></h4>
        </div>
        <div class="content-body">
            <!-- packages list start -->
            <section class="app-package-list">
                <!-- list and filter start -->
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive pt-0">
                            <table id="tbl-bootstr" class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th><?php echo e(__('Name')); ?></th>
                                        <th><?php echo e(__('Description')); ?></th>
                                        <th><?php echo e(__('Monthly')); ?></th>
                                        <!-- <th><?php echo e(__('Yearly')); ?></th> -->
                                        <th><?php echo e(__('Outgoing')); ?></th>
                                        <th><?php echo e(__('Devices')); ?></th>
                                        <th><?php echo e(__('Autoreply Keyword')); ?></th>
                                        <th><?php echo e(__('Phonebooks')); ?></th>
                                        <th><?php echo e(__('Global senders')); ?></th>
                                        <th><?php echo e(__('Webhook')); ?></th>
                                        <th><?php echo e(__('Footer')); ?></th>
                                        <th><?php echo e(__('Actions')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><a href="javascript:;" data-bs-target="#edit-<?php echo e($package->id); ?>" data-bs-toggle="modal">
                                        <span class="badge rounded-pill badge-light-<?php echo e($package->hidden ? 'danger' : 'primary'); ?> me-1"><?php echo e($package->name); ?></span></a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-<?php echo e($package->id); ?>" data-bs-toggle="modal">
                                        <?php echo e($package->description); ?></a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-<?php echo e($package->id); ?>" data-bs-toggle="modal">
                                        <?php echo e(number_format($package->rate_monthly,\App\Helpers\Helpers::setting('nfDecimals'),\App\Helpers\Helpers::setting('nfDecimalpoint'),\App\Helpers\Helpers::setting('nfSeparator'))); ?></a>
                                        </td>
                                        <!-- <td><a href="javascript:;" data-bs-target="#edit-<?php echo e($package->id); ?>" data-bs-toggle="modal">
                                        <?php echo e($package->rate_yearly); ?></a>
                                        </td> -->
                                        <td><a href="javascript:;" data-bs-target="#edit-<?php echo e($package->id); ?>" data-bs-toggle="modal">
                                        <?php echo e($package->max_outgoing < 0 ? __('Unlimited') : number_format($package->max_outgoing,0,\App\Helpers\Helpers::setting('nfDecimalpoint'),\App\Helpers\Helpers::setting('nfSeparator'))); ?></a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-<?php echo e($package->id); ?>" data-bs-toggle="modal">
                                        <?php echo e($package->max_device < 0 ? __('Unlimited') : $package->max_device); ?></a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-<?php echo e($package->id); ?>" data-bs-toggle="modal">
                                        <?php echo e($package->max_autoreply < 0 ? __('Unlimited') : $package->max_autoreply); ?></a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-<?php echo e($package->id); ?>" data-bs-toggle="modal">
                                        <?php echo e($package->max_phonebook < 0 ? __('Unlimited') : $package->max_phonebook); ?></a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-<?php echo e($package->id); ?>" data-bs-toggle="modal">
                                        <span class="badge rounded-pill badge-light-<?php echo e($package->global_senders?'success':'danger'); ?> me-1"><?php echo e($package->global_senders ? __('YES') : __('NO')); ?></span></a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-<?php echo e($package->id); ?>" data-bs-toggle="modal">
                                        <span class="badge rounded-pill badge-light-<?php echo e($package->webhook?'success':'danger'); ?> me-1"><?php echo e($package->webhook ? __('YES') : __('NO')); ?></span></a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-<?php echo e($package->id); ?>" data-bs-toggle="modal">
                                        <span class="badge rounded-pill badge-light-<?php echo e($package->footer?'success':'danger'); ?> me-1"><?php echo e($package->footer ? __('YES') : __('NO')); ?></span></a>
                                        </td>
                                        <td>
                                            <?php if($package->id > 2): ?>
                                            <button class="btn btn-warning dropdown-toggle" type="button" id="actionButton-<?php echo e($package->id); ?>" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i data-feather="command" class="me-0"></i>
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="actionButton-<?php echo e($package->id); ?>">
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#edit-<?php echo e($package->id); ?>"><i data-feather="edit" class="me-0"></i> <?php echo e(__('Edit')); ?></a>
                                                <div class="dropdown-divider"></div>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroy-<?php echo e($package->id); ?>"><i data-feather="trash" class="me-0"></i> <?php echo e(__('Delete')); ?></a>
                                            </div>
                                            <?php else: ?>
                                            <span class="badge bg-secondary"><?php echo e(__('System')); ?></span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php if($package->id > 2): ?>
                                    <!-- Delete Modal -->
                                    <div class="modal fade modal-danger text-start" id="destroy-<?php echo e($package->id); ?>" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel120"><?php echo e(__('Delete confirmation')); ?></h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <?php echo e(__('Are you sure you want to delete?')); ?> <br><br>
                                                    <span class="text text-danger"> <b><?php echo e($package->name); ?></b> </span><br><br>
                                                    <?php echo e(__('This process is irreversible')); ?> <br>
                                                    <?php echo e(__('The record(s) will be deleted from the database permanently')); ?>

                                                </div>
                                                <div class="modal-footer">
                                                <a class="btn btn-sm btn-danger" href="<?php echo e(route('package.destroy', ['package_id' => $package->id])); ?>"><?php echo e(__('Delete')); ?></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                    <!-- Edit Package Modal -->
                                    <div class="modal fade" id="edit-<?php echo e($package->id); ?>" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-xl modal-dialog-centered modal-edit-package">
                                            <div class="modal-content">
                                                <div class="modal-header bg-transparent">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body pb-5 px-sm-5 pt-50">
                                                    <div class="text-center mb-2">
                                                        <h1 class="mb-1"><?php echo e(__('Edit package form')); ?></h1>
                                                    </div>
                                                    <form action="<?php echo e(route('package.update')); ?>" method="POST" id="editPackageForm" class="row gy-1 pt-75">
                                                        <?php echo csrf_field(); ?>
                                                        <div class="row">
                                                        <div class="col-12 col-md-6">
                                                            <input type="hidden"  name="package_id" value="<?php echo e($package->id); ?>" />
                                                            <label class="form-label" for="name"><?php echo e(__('Package name')); ?></label>
                                                            <input type="text" name="name" class="form-control" value="<?php echo e($package->name); ?>" placeholder="<?php echo e(__('Package name')); ?>" required />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="description"><?php echo e(__('Description')); ?></label>
                                                            <input type="text" name="description" class="form-control" value="<?php echo e($package->description); ?>" placeholder="<?php echo e(__('Description')); ?>" required />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="rate_monthly"><?php echo e(__('Price monthly')); ?></label>
                                                            <input type="number" name="rate_monthly" step="0.01" class="form-control" value="<?php echo e($package->rate_monthly); ?>" placeholder="<?php echo e(__('Price monthly')); ?>" required />
                                                        </div>
                                                        <!-- <div class="col-12 col-md-6">
                                                            <label class="form-label" for="rate_yearly"><?php echo e(__('Price yearly')); ?></label>
                                                            <input type="number" name="rate_yearly" step="0.01" class="form-control" value="<?php echo e($package->rate_yearly); ?>" placeholder="<?php echo e(__('Price yearly')); ?>" <?php echo e(($package->name === 'super' ? 'readonly' : '')); ?> required />
                                                        </div> -->
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="max_outgoing"><?php echo e(__('Max Outgoing')); ?></label>
                                                            <label class="form-label text-warning">(-1 = <?php echo e(__('Unlimited')); ?>)</label>
                                                            <input type="number" name="max_outgoing" class="form-control" value="<?php echo e($package->max_outgoing); ?>" placeholder="<?php echo e(__('Max Outgoing')); ?>" required />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="max_device"><?php echo e(__('Max Device')); ?></label>
                                                            <label class="form-label text-warning">(-1 = <?php echo e(__('Unlimited')); ?>)</label>
                                                            <input type="number" name="max_device" class="form-control" value="<?php echo e($package->max_device); ?>" placeholder="<?php echo e(__('Max Device')); ?>" required />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="max_autoreply"><?php echo e(__('Max Autoreply Keyword')); ?></label>
                                                            <label class="form-label text-warning">(-1 = <?php echo e(__('Unlimited')); ?>)</label>
                                                            <input type="number" name="max_autoreply" class="form-control" value="<?php echo e($package->max_autoreply); ?>" placeholder="<?php echo e(__('Max Autoreply Keyword')); ?>" required />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="max_phonebook"><?php echo e(__('Max Phonebook')); ?></label>
                                                            <label class="form-label text-warning">(-1 = <?php echo e(__('Unlimited')); ?>)</label>
                                                            <input type="number" name="max_phonebook" class="form-control" value="<?php echo e($package->max_phonebook); ?>" placeholder="<?php echo e(__('Max Phonebook')); ?>" required />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="global_senders"><?php echo e(__('Global senders')); ?></label>
                                                            <select name="global_senders" class="form-select">
                                                                <option value="0" <?php echo e(!$package->global_senders ? 'selected' : ''); ?>><?php echo e(__('Global senders Disabled')); ?></option>
                                                                <option value="1" <?php echo e($package->global_senders ? 'selected' : ''); ?>><?php echo e(__('Global senders Enabled')); ?></option>
                                                            </select>
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="webhook"><?php echo e(__('Webhook')); ?></label>
                                                            <select name="webhook" class="form-select">
                                                                <option value="0" <?php echo e(!$package->webhook ? 'selected' : ''); ?>><?php echo e(__('Webhook Disabled')); ?></option>
                                                                <option value="1" <?php echo e($package->webhook ? 'selected' : ''); ?>><?php echo e(__('Webhook Enabled')); ?></option>
                                                            </select>
                                                            <label class="form-label text-warning"><?php echo e(__('_MsgWebhookWarning')); ?></label>
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="hidden"><?php echo e(__('Hidden')); ?></label>
                                                            <select name="hidden" class="form-select">
                                                                <option value="0" <?php echo e(!$package->hidden ? 'selected' : ''); ?>><?php echo e(__('NO')); ?></option>
                                                                <option value="1" <?php echo e($package->hidden ? 'selected' : ''); ?>><?php echo e(__('YES')); ?></option>
                                                            </select>
                                                        </div>
                                                        <div class="col-12">
                                                            <label class="form-label" for="footer"><?php echo e(__('Footer Message')); ?></label>
                                                            <textarea class="form-control" name="footer" rows="5"><?php echo e($package->footer); ?></textarea>
                                                        </div>
                                                        <div class="col-12 text-center mt-2 pt-50">
                                                            <button type="submit" class="btn btn-primary me-1"><?php echo e(__('Submit')); ?></button>
                                                            <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close"><?php echo e(__('Cancel')); ?></button>
                                                        </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--/ Edit Package Modal -->
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <!-- Modal to add new package starts-->
                        <div class="modal modal-slide-in new-package-modal fade" id="addNew">
                            <div class="modal-dialog">
                                <form action="<?php echo e(route('package.store')); ?>" method="POST"  class="add-new-package modal-content pt-0">
                                <?php echo csrf_field(); ?>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
                                    <div class="modal-header mb-1">
                                        <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('Add new package')); ?></h5>
                                    </div>
                                    <div class="modal-body flex-grow-1">
                                        <div class="mb-1">
                                            <label class="form-label" for="name"><?php echo e(__('Package name')); ?></label>
                                            <input type="text" name="name" class="form-control" placeholder="<?php echo e(__('Package name')); ?>" required />
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="description"><?php echo e(__('Description')); ?></label>
                                            <input type="text" name="description" class="form-control" placeholder="<?php echo e(__('Description')); ?>" required />
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="rate_monthly"><?php echo e(__('Price monthly')); ?></label>
                                            <input type="number" name="rate_monthly" step="0.01" class="form-control" placeholder="<?php echo e(__('Price monthly')); ?>" required />
                                        </div>
                                        <!-- <div class="mb-1">
                                            <label class="form-label" for="rate_yearly"><?php echo e(__('Price yearly')); ?></label>
                                            <input type="number" name="rate_yearly" step="0.01" class="form-control" placeholder="<?php echo e(__('Price yearly')); ?>" required />
                                        </div> -->
                                        <div class="mb-1">
                                            <label class="form-label" for="max_outgoing"><?php echo e(__('Max Outgoing')); ?></label>
                                            <label class="form-label text-warning">(-1 = <?php echo e(__('Unlimited')); ?>)</label>
                                            <input type="number" name="max_outgoing"class="form-control" placeholder="<?php echo e(__('Max Outgoing')); ?>" required />
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="max_device"><?php echo e(__('Max Device')); ?></label>
                                            <label class="form-label text-warning">(-1 = <?php echo e(__('Unlimited')); ?>)</label>
                                            <input type="number" name="max_device" class="form-control" placeholder="<?php echo e(__('Max Device')); ?>" required />
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="max_autoreply"><?php echo e(__('Max Autoreply Keyword')); ?></label>
                                            <label class="form-label text-warning">(-1 = <?php echo e(__('Unlimited')); ?>)</label>
                                            <input type="number" name="max_autoreply" class="form-control" placeholder="<?php echo e(__('Max Autoreply Keyword')); ?>" required />
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="max_phonebook"><?php echo e(__('Max Phonebook')); ?></label>
                                            <label class="form-label text-warning">(-1 = <?php echo e(__('Unlimited')); ?>)</label>
                                            <input type="number" name="max_phonebook" class="form-control" placeholder="<?php echo e(__('Max Phonebook')); ?>" required />
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="global_senders"><?php echo e(__('Global senders')); ?></label>
                                            <select name="global_senders" class="form-select">
                                                <option value="0" selected><?php echo e(__('Global senders Disabled')); ?></option>
                                                <option value="1"><?php echo e(__('Global senders Enabled')); ?></option>
                                            </select>
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="webhook"><?php echo e(__('Webhook')); ?></label>
                                            <select name="webhook" class="form-select">
                                                <option value="0" selected><?php echo e(__('Webhook Disabled')); ?></option>
                                                <option value="1"><?php echo e(__('Webhook Enabled')); ?></option>
                                            </select>
                                            <label class="form-label text-warning"><?php echo e(__('_MsgWebhookWarning')); ?></label>
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="footer"><?php echo e(__('Footer Message')); ?></label>
                                            <textarea class="form-control" name="footer" rows="5"></textarea>
                                        </div>
                                        <button type="submit" class="btn btn-primary me-1 data-submit"><?php echo e(__('Submit')); ?></button>
                                        <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- Modal to add new package Ends-->
                    </div>
                </div>
                <!-- list and filter end -->
            </section>
            <!-- packages list ends -->
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- BEGIN: Vendor JS-->
<script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/vendors.min.js"></script>
<script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js"></script>
<script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/tables/datatable/dataTables.bootstrap5.min.js"></script>
<!-- BEGIN Vendor JS-->
<script>
    $(document).ready(function () {
        $('#tbl-bootstr').DataTable();
    });        
</script>

<?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home/procharmate/public_html/whatsapp.procharmate.com/resources/views//package-list.blade.php ENDPATH**/ ?>