<?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php
App::setLocale(Auth::user()->lang);
?>

<link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/vendors/css/tables/datatable/dataTables.bootstrap5.min.css">

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-header row">
            <h4><?php echo e(__('Offline Payments Management')); ?><span class="badge rounded-pill badge-light-warning ms-2"><?php echo e($pendingCount); ?></span></h4>
        </div>
        <div class="content-body">
            <!-- Statistics Cards -->
            <div class="row">
                <div class="col-xl-3 col-sm-6 col-12 mb-2">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h2 class="fw-bolder"><?php echo e($pendingCount); ?></h2>
                                    <p class="card-text"><?php echo e(__('Pending')); ?></p>
                                </div>
                                <div class="avatar bg-light-warning p-50 mb-0">
                                    <div class="avatar-content">
                                        <i data-feather="clock" class="font-medium-5"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6 col-12 mb-2">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h2 class="fw-bolder"><?php echo e($approvedCount); ?></h2>
                                    <p class="card-text"><?php echo e(__('Approved')); ?></p>
                                </div>
                                <div class="avatar bg-light-success p-50 mb-0">
                                    <div class="avatar-content">
                                        <i data-feather="check-circle" class="font-medium-5"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6 col-12 mb-2">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h2 class="fw-bolder"><?php echo e($rejectedCount); ?></h2>
                                    <p class="card-text"><?php echo e(__('Rejected')); ?></p>
                                </div>
                                <div class="avatar bg-light-danger p-50 mb-0">
                                    <div class="avatar-content">
                                        <i data-feather="x-circle" class="font-medium-5"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6 col-12 mb-2">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h2 class="fw-bolder"><?php echo e(number_format($totalAmount, 2)); ?></h2>
                                    <p class="card-text"><?php echo e(__('Total Amount')); ?></p>
                                </div>
                                <div class="avatar bg-light-primary p-50 mb-0">
                                    <div class="avatar-content">
                                        <i data-feather="dollar-sign" class="font-medium-5"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Offline Payments List -->
            <section class="app-offline-payment-list">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive pt-0">
                            <table id="tbl-bootstr" class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th><?php echo e(__('ID')); ?></th>
                                        <th><?php echo e(__('User')); ?></th>
                                        <th><?php echo e(__('Amount')); ?></th>
                                        <th><?php echo e(__('Reference')); ?></th>
                                        <th><?php echo e(__('Proof')); ?></th>
                                        <th><?php echo e(__('Status')); ?></th>
                                        <th><?php echo e(__('Date')); ?></th>
                                        <th><?php echo e(__('Actions')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($payment->id); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('user.show', ['user_id' => $payment->user_id])); ?>">
                                                <?php echo e($payment->user->name ?? 'N/A'); ?><br>
                                                <small class="text-muted"><?php echo e($payment->user->email ?? ''); ?></small>
                                            </a>
                                        </td>
                                        <td>
                                            <?php
                                                // Get requested amount from data field for pending payments
                                                $displayAmount = $payment->amount;
                                                if ($payment->gateway_status === 'pending' && $payment->data) {
                                                    $paymentData = is_array($payment->data) ? $payment->data : json_decode($payment->data, true);
                                                    $displayAmount = $paymentData['requested_amount'] ?? $payment->amount;
                                                }
                                            ?>
                                            <span class="badge badge-light-primary">
                                                <?php echo e(number_format($displayAmount, 2)); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <small><?php echo e($payment->gateway_reference); ?></small>
                                        </td>
                                        <td>
                                            <?php if($payment->proof_of_payment): ?>
                                                <a href="<?php echo e(Storage::url($payment->proof_of_payment)); ?>" target="_blank" class="btn btn-sm btn-outline-primary">
                                                    <i data-feather="eye" class="me-0"></i> <?php echo e(__('View')); ?>

                                                </a>
                                            <?php else: ?>
                                                <span class="text-muted"><?php echo e(__('No proof')); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php
                                                $statusColors = [
                                                    'pending' => 'warning',
                                                    'success' => 'success',
                                                    'approved' => 'success',
                                                    'rejected' => 'danger',
                                                    'failed' => 'danger'
                                                ];
                                                $color = $statusColors[$payment->gateway_status] ?? 'secondary';
                                            ?>
                                            <span class="badge bg-<?php echo e($color); ?>"><?php echo e(ucfirst($payment->gateway_status)); ?></span>
                                        </td>
                                        <td>
                                            <small><?php echo e($payment->created_at->format('Y-m-d H:i')); ?></small>
                                        </td>
                                        <td>
                                            <?php if($payment->gateway_status === 'pending'): ?>
                                                <button class="btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#approve-<?php echo e($payment->id); ?>">
                                                    <i data-feather="check" class="me-0"></i> <?php echo e(__('Approve')); ?>

                                                </button>
                                                <button class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#reject-<?php echo e($payment->id); ?>">
                                                    <i data-feather="x" class="me-0"></i> <?php echo e(__('Reject')); ?>

                                                </button>
                                            <?php else: ?>
                                                <span class="badge bg-secondary"><?php echo e(__('Processed')); ?></span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>

                                    <!-- Approve Modal -->
                                    <div class="modal fade modal-success text-start" id="approve-<?php echo e($payment->id); ?>" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title"><?php echo e(__('Approve Payment')); ?></h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <?php
                                                        // Get requested amount for modal
                                                        $modalAmount = $payment->amount;
                                                        if ($payment->gateway_status === 'pending' && $payment->data) {
                                                            $modalData = is_array($payment->data) ? $payment->data : json_decode($payment->data, true);
                                                            $modalAmount = $modalData['requested_amount'] ?? $payment->amount;
                                                        }
                                                    ?>
                                                    <?php echo e(__('Are you sure you want to approve this payment?')); ?><br><br>
                                                    <strong><?php echo e(__('User')); ?>:</strong> <?php echo e($payment->user->name ?? 'N/A'); ?><br>
                                                    <strong><?php echo e(__('Amount')); ?>:</strong> <?php echo e(number_format($modalAmount, 2)); ?><br>
                                                    <strong><?php echo e(__('Reference')); ?>:</strong> <?php echo e($payment->gateway_reference); ?><br><br>
                                                    <span class="text-success"><?php echo e(__('The amount will be added to the user\'s wallet balance.')); ?></span>
                                                </div>
                                                <div class="modal-footer">
                                                    <form action="<?php echo e(route('transaction.approveOffline', ['transaction_id' => $payment->id])); ?>" method="POST">
                                                        <?php echo csrf_field(); ?>
                                                        <button type="submit" class="btn btn-success"><?php echo e(__('Approve')); ?></button>
                                                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Reject Modal -->
                                    <div class="modal fade modal-danger text-start" id="reject-<?php echo e($payment->id); ?>" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title"><?php echo e(__('Reject Payment')); ?></h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <form action="<?php echo e(route('transaction.rejectOffline', ['transaction_id' => $payment->id])); ?>" method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <div class="modal-body">
                                                        <?php
                                                            // Get requested amount for reject modal
                                                            $rejectAmount = $payment->amount;
                                                            if ($payment->gateway_status === 'pending' && $payment->data) {
                                                                $rejectData = is_array($payment->data) ? $payment->data : json_decode($payment->data, true);
                                                                $rejectAmount = $rejectData['requested_amount'] ?? $payment->amount;
                                                            }
                                                        ?>
                                                        <?php echo e(__('Are you sure you want to reject this payment?')); ?><br><br>
                                                        <strong><?php echo e(__('User')); ?>:</strong> <?php echo e($payment->user->name ?? 'N/A'); ?><br>
                                                        <strong><?php echo e(__('Amount')); ?>:</strong> <?php echo e(number_format($rejectAmount, 2)); ?><br>
                                                        <strong><?php echo e(__('Reference')); ?>:</strong> <?php echo e($payment->gateway_reference); ?><br><br>
                                                        
                                                        <div class="mb-1">
                                                            <label class="form-label" for="reason"><?php echo e(__('Reason for Rejection')); ?></label>
                                                            <textarea name="reason" class="form-control" rows="3" placeholder="<?php echo e(__('Optional: Provide a reason...')); ?>"></textarea>
                                                        </div>
                                                        
                                                        <span class="text-danger"><?php echo e(__('This action cannot be undone.')); ?></span>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="submit" class="btn btn-danger"><?php echo e(__('Reject')); ?></button>
                                                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- BEGIN: Vendor JS-->
<script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/vendors.min.js"></script>
<script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js"></script>
<script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/tables/datatable/dataTables.bootstrap5.min.js"></script>
<!-- BEGIN Vendor JS-->
<script>
    $(document).ready(function () {
        $('#tbl-bootstr').DataTable({
            order: [[0, 'desc']]
        });
    });        
</script>

<?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home/procharmate/public_html/whatsapp.procharmate.com/resources/views/offline-payments.blade.php ENDPATH**/ ?>