<?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php
App::setLocale(Auth::user()->lang);
?>

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <!-- header info start -->
        <div class="row">
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75"><?php echo e($totalIntents); ?></h3>
                            <span><?php echo e(__('Total Intents')); ?></span>
                        </div>
                        <div class="avatar bg-light-primary p-50">
                            <span class="avatar-content">
                                <i data-feather="message-circle" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75"><?php echo e($activeIntents); ?></h3>
                            <span><?php echo e(__('Active Intents')); ?></span>
                        </div>
                        <div class="avatar bg-light-success p-50">
                            <span class="avatar-content">
                                <i data-feather="check-circle" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75"><?php echo e($totalSessions); ?></h3>
                            <span><?php echo e(__('Total Sessions')); ?></span>
                        </div>
                        <div class="avatar bg-light-info p-50">
                            <span class="avatar-content">
                                <i data-feather="users" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75"><?php echo e($totalResponses); ?></h3>
                            <span><?php echo e(__('Total Responses')); ?></span>
                        </div>
                        <div class="avatar bg-light-warning p-50">
                            <span class="avatar-content">
                                <i data-feather="send" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- header info end -->
        <div class="content-body">
            <!-- Tabs -->
            <ul class="nav nav-pills mb-2" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active" id="intents-tab" data-bs-toggle="pill" href="#intents" role="tab">
                        <i data-feather="message-circle" class="font-medium-3 me-50"></i>
                        <span class="fw-bold"><?php echo e(__('Intents')); ?></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="sessions-tab" data-bs-toggle="pill" href="#sessions" role="tab">
                        <i data-feather="activity" class="font-medium-3 me-50"></i>
                        <span class="fw-bold"><?php echo e(__('Sessions')); ?></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="responses-tab" data-bs-toggle="pill" href="#responses" role="tab">
                        <i data-feather="mail" class="font-medium-3 me-50"></i>
                        <span class="fw-bold"><?php echo e(__('Response Log')); ?></span>
                    </a>
                </li>
            </ul>

            <div class="tab-content">
                <!-- Intents Tab -->
                <div class="tab-pane active" id="intents" role="tabpanel">
                    <section class="app-chatbot-intents">
                        <div class="card">
                            <h5 class="card-header">
                                <div class="input-group input-group-sm position-relative mx-auto">
                                    <?php echo e(__('Chatbot Intents')); ?><span class="badge badge-light-secondary ms-2"><?php echo e($intents->total()); ?></span>
                                    <input type="search" class="form-control" id="search-intent" placeholder="<?php echo e(__('Search')); ?>..." />
                                    <button type="button" class="btn btn-sm btn-info" id="searchbtn-intent"><i data-feather="search" class="me-0"></i></button>
                                    <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#addIntent">
                                        <i data-feather="plus" class="me-1"></i><?php echo e(strtoupper(__('Add Intent'))); ?>

                                    </button>
                                </div>
                            </h5>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead class="table-light">
                                            <tr>
                                                <th><?php echo e(__('Chatbot')); ?></th>
                                                <th><?php echo e(__('Pattern')); ?></th>
                                                <th><?php echo e(__('Response')); ?></th>
                                                <th><?php echo e(__('Category')); ?></th>
                                                <th><?php echo e(__('Priority')); ?></th>
                                                <th><?php echo e(__('Status')); ?></th>
                                                <th><?php echo e(__('Actions')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__empty_1 = true; $__currentLoopData = $intents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $intent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td><strong><?php echo e($intent->chatbot->name ?? 'N/A'); ?></strong></td>
                                                <td>
                                                    <span class="badge badge-light-primary"><?php echo e(\Str::limit($intent->pattern, 30)); ?></span>
                                                </td>
                                                <td><small><?php echo e(\Str::limit($intent->response, 50)); ?></small></td>
                                                <td><span class="badge badge-light-info"><?php echo e(ucfirst($intent->category)); ?></span></td>
                                                <td><span class="badge badge-light-secondary"><?php echo e($intent->priority); ?></span></td>
                                                <td>
                                                    <?php if($intent->is_active): ?>
                                                        <span class="badge badge-light-success"><?php echo e(__('Active')); ?></span>
                                                    <?php else: ?>
                                                        <span class="badge badge-light-secondary"><?php echo e(__('Inactive')); ?></span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <div class="dropdown">
                                                        <button type="button" class="btn btn-sm btn-icon dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                                            <i data-feather="more-vertical"></i>
                                                        </button>
                                                        <div class="dropdown-menu">
                                                            <a class="dropdown-item" href="#" onclick="editIntent(<?php echo e($intent->id); ?>)">
                                                                <i data-feather="edit" class="me-50"></i><?php echo e(__('Edit')); ?></a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <tr>
                                                <td colspan="7" class="text-center text-muted py-4">
                                                    <?php echo e(__('No intents found. Create your first intent using the "Add Intent" button above.')); ?>

                                                </td>
                                            </tr>
                                            <?php endif; ?>
                                                            <a class="dropdown-item" href="#" onclick="toggleIntent(<?php echo e($intent->id); ?>)">
                                                                <i data-feather="toggle-<?php echo e($intent->is_active ? 'left' : 'right'); ?>" class="me-50"></i><?php echo e($intent->is_active ? __('Deactivate') : __('Activate')); ?>

                                                            </a>
                                                            <a class="dropdown-item text-danger" href="#" onclick="deleteIntent(<?php echo e($intent->id); ?>)">
                                                                <i data-feather="trash" class="me-50"></i><?php echo e(__('Delete')); ?>

                                                            </a>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="d-flex justify-content-center mt-3">
                                    <?php echo e($intents->links()); ?>

                                </div>
                            </div>
                        </div>
                    </section>
                </div>

                <!-- Sessions Tab -->
                <div class="tab-pane" id="sessions" role="tabpanel">
                    <section class="app-chatbot-sessions">
                        <div class="card">
                            <h5 class="card-header"><?php echo e(__('Active Chatbot Sessions')); ?></h5>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead class="table-light">
                                            <tr>
                                                <th><?php echo e(__('Session ID')); ?></th>
                                                <th><?php echo e(__('User Phone')); ?></th>
                                                <th><?php echo e(__('Current State')); ?></th>
                                                <th><?php echo e(__('Started')); ?></th>
                                                <th><?php echo e(__('Last Activity')); ?></th>
                                                <th><?php echo e(__('Actions')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><code><?php echo e(\Str::limit($session->session_id, 20)); ?></code></td>
                                                <td><strong><?php echo e($session->user_phone); ?></strong></td>
                                                <td><span class="badge badge-light-primary"><?php echo e($session->current_state ?? 'idle'); ?></span></td>
                                                <td><?php echo e($session->created_at->diffForHumans()); ?></td>
                                                <td><?php echo e($session->updated_at->diffForHumans()); ?></td>
                                                <td>
                                                    <button type="button" class="btn btn-sm btn-outline-primary" onclick="viewSession('<?php echo e($session->session_id); ?>')">
                                                        <i data-feather="eye" class="me-50"></i><?php echo e(__('View')); ?>

                                                    </button>
                                                    <button type="button" class="btn btn-sm btn-outline-danger" onclick="endSession('<?php echo e($session->session_id); ?>')">
                                                        <i data-feather="x-circle" class="me-50"></i><?php echo e(__('End')); ?>

                                                    </button>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="d-flex justify-content-center mt-3">
                                    <?php echo e($sessions->links()); ?>

                                </div>
                            </div>
                        </div>
                    </section>
                </div>

                <!-- Responses Tab -->
                <div class="tab-pane" id="responses" role="tabpanel">
                    <section class="app-chatbot-responses">
                        <div class="card">
                            <h5 class="card-header"><?php echo e(__('Response Log')); ?></h5>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead class="table-light">
                                            <tr>
                                                <th><?php echo e(__('Session')); ?></th>
                                                <th><?php echo e(__('User Phone')); ?></th>
                                                <th><?php echo e(__('Intent Matched')); ?></th>
                                                <th><?php echo e(__('User Message')); ?></th>
                                                <th><?php echo e(__('Bot Response')); ?></th>
                                                <th><?php echo e(__('Time')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $responses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $response): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><code><?php echo e(\Str::limit($response->session_id, 15)); ?></code></td>
                                                <td><?php echo e($response->user_phone); ?></td>
                                                <td>
                                                    <?php if($response->intent): ?>
                                                        <span class="badge badge-light-success"><?php echo e($response->intent->intent_name); ?></span>
                                                    <?php else: ?>
                                                        <span class="badge badge-light-secondary"><?php echo e(__('No match')); ?></span>
                                                    <?php endif; ?>
                                                </td>
                                                <td><small><?php echo e(\Str::limit($response->user_message, 40)); ?></small></td>
                                                <td><small><?php echo e(\Str::limit($response->bot_response, 40)); ?></small></td>
                                                <td><?php echo e($response->created_at->format('M d, h:i A')); ?></td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="d-flex justify-content-center mt-3">
                                    <?php echo e($responses->links()); ?>

                                </div>
                            </div>
                        </div>
                    </section>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- Modal Add Intent -->
<div class="modal fade" id="addIntent" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(__('Create New Intent')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="<?php echo e(route('chatbot.intent.store')); ?>">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label"><?php echo e(__('Select Chatbot')); ?>*</label>
                        <select name="chatbot_id" class="form-select" required>
                            <option value=""><?php echo e(__('Choose a chatbot')); ?></option>
                            <?php $__currentLoopData = $chatbots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($bot->id); ?>"><?php echo e($bot->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label"><?php echo e(__('Pattern')); ?>*</label>
                        <input type="text" name="pattern" class="form-control" placeholder="e.g., hello, hi, hey" required>
                        <small class="text-muted"><?php echo e(__('Keywords or phrases that trigger this response')); ?></small>
                    </div>
                    <div class="mb-3">
                        <label class="form-label"><?php echo e(__('Response Text')); ?>*</label>
                        <textarea name="response" class="form-control" rows="4" required placeholder="<?php echo e(__('Hello! How can I help you today?')); ?>"></textarea>
                        <small class="text-muted"><?php echo e(__('The message to send when this intent is matched')); ?></small>
                    </div>
                    <div class="mb-3">
                        <label class="form-label"><?php echo e(__('Category')); ?></label>
                        <select name="category" class="form-select">
                            <option value="general" selected><?php echo e(__('General')); ?></option>
                            <option value="greeting"><?php echo e(__('Greeting')); ?></option>
                            <option value="faq"><?php echo e(__('FAQ')); ?></option>
                            <option value="support"><?php echo e(__('Support')); ?></option>
                            <option value="sales"><?php echo e(__('Sales')); ?></option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label"><?php echo e(__('Priority')); ?></label>
                        <select name="priority" class="form-select">
                            <option value="0" selected><?php echo e(__('Low')); ?></option>
                            <option value="5"><?php echo e(__('Medium')); ?></option>
                            <option value="10"><?php echo e(__('High')); ?></option>
                        </select>
                        <small class="text-muted"><?php echo e(__('Higher priority intents are matched first')); ?></small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                    <button type="submit" class="btn btn-primary"><?php echo e(__('Create Intent')); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<script>
function toggleIntent(id) {
    fetch('/chatbot-intent-toggle', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        },
        body: JSON.stringify({ intent_id: id })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        }
    });
}

function deleteIntent(id) {
    if (confirm('<?php echo e(__("Delete this intent? This cannot be undone.")); ?>')) {
        window.location.href = `/chatbot-intent-destroy?intent_id=${id}`;
    }
}

function endSession(sessionId) {
    if (confirm('<?php echo e(__("End this chatbot session?")); ?>')) {
        fetch('/chatbot-session-end', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify({ session_id: sessionId })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            }
        });
    }
}

// Re-initialize Feather icons after tab switch
document.querySelectorAll('a[data-bs-toggle="pill"]').forEach(tab => {
    tab.addEventListener('shown.bs.tab', function() {
        feather.replace();
    });
});
</script>
<?php /**PATH /home/procharmate/public_html/whatsapp.procharmate.com/resources/views/chatbot-list.blade.php ENDPATH**/ ?>