<?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php
App::setLocale(Auth::user()->lang);
?>
    <!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
            </div>
            <div class="content-body">
                <section class="app-user-view-security">
                    <div class="row">
                        <!-- User Sidebar -->
                        <div class="col-xl-8 col-lg-7 col-md-7 order-1 order-md-0">
                            <!-- User Card -->
                            <div class="card border-primary">
                            <div class="row">
                                <div class="card-body col-xl-3 col-lg-4 col-md-4">
                                    <a href="javascript:;" class="user-avatar-section" data-bs-target="#updateAvatar" data-bs-toggle="modal">
                                        <div class="d-flex align-items-center flex-column">
                                            <img class="img-fluid rounded mt-3 mb-2" src="<?php echo e(\App\Helpers\Helpers::avatarUrl()); ?>" height="110" width="110" alt="User avatar" />
                                            <div class="user-info text-center">
                                                <h4><?php echo e($user->name); ?></h4>
                                                <span class="badge bg-light-secondary"><?php echo e($user->package->name); ?></span>
                                            </div>
                                        </div>
                                    </a>
                                    <div class="d-flex justify-content-around my-2 pt-75">
                                        <div class="d-flex align-items-start me-2">
                                            <span class="badge bg-light-primary p-75 rounded">
                                                <i data-feather="check" class="font-medium-2"></i>
                                            </span>
                                            <div class="ms-75">
                                                <h4 class="mb-0"><?php echo e($user->current_sent); ?></h4>
                                                <small><?php echo e(__('Current sent')); ?></small>
                                            </div>
                                        </div>
                                        <div class="d-flex align-items-start">
                                            <span class="badge bg-light-primary p-75 rounded">
                                                <i data-feather="briefcase" class="font-medium-2"></i>
                                            </span>
                                            <div class="ms-75">
                                                <h4 class="mb-0"><?php echo e($user->total_sent); ?></h4>
                                                <small><?php echo e(__('Total sent')); ?></small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body col-xl-3 col-lg-4 col-md-4">
                                    <h4 class="fw-bolder border-bottom pb-50 mb-1"><?php echo e(__('Details')); ?></h4>
                                    <div class="info-container">
                                        <ul class="list-unstyled">
                                            <li class="mb-75">
                                                <span class="fw-bolder me-25"><?php echo e(__('Username')); ?>:</span>
                                                <span><?php echo e($user->name); ?></span>
                                            </li>
                                            <li class="mb-75">
                                                <span class="fw-bolder me-25"><?php echo e(__('Email')); ?>:</span>
                                                <span><?php echo e($user->email); ?></span>
                                            </li>
                                            <li class="mb-75">
                                                <span class="fw-bolder me-25"><?php echo e(__('Phone')); ?>:</span>
                                                <span><?php echo e($user->phone); ?></span>
                                            </li>
                                            <li class="mb-75">
                                                <span class="fw-bolder me-25"><?php echo e(__('Status')); ?>:</span>
                                                <span class="badge bg-light-<?php echo e(($status == 'ACTIVE') ? 'success' : 'danger'); ?>"><?php echo e($status); ?></span>
                                            </li>
                                            <li class="mb-75">
                                                <span class="fw-bolder me-25"><?php echo e(__('Role')); ?>:</span>
                                                <span><?php echo e($user->role); ?></span>
                                            </li>
                                            <li class="mb-75">
                                                <span class="fw-bolder me-25"><?php echo e(__('Language')); ?>:</span>
                                                <span><?php echo e($user->lang); ?></span>
                                            </li>
                                            <li class="mb-75">
                                                <span class="fw-bolder me-25"><?php echo e(__('Panel theme')); ?>:</span>
                                                <span><?php echo e($user->theme); ?></span>
                                            </li>
                                            <?php if(\App\Helpers\Helpers::isEx()): ?>
                                            <li class="mb-75">
                                                <span class="fw-bolder me-25"><?php echo e(__('Package')); ?>:</span>
                                                <span><?php echo e($user->package->description); ?></span>
                                            </li>
                                            <li class="mb-75">
                                                <span class="fw-bolder me-25"><?php echo e(__('Wallet')); ?>:</span>
                                                <?php if($walletBalance < 0): ?>
                                                <span class="badge rounded-pill badge-light-danger me-1">
                                                <?php else: ?>
                                                <span class="badge rounded-pill badge-light-success me-1">
                                                <?php endif; ?>
                                                <?php echo e(number_format($walletBalance,\App\Helpers\Helpers::setting('nfDecimals'),\App\Helpers\Helpers::setting('nfDecimalpoint'),\App\Helpers\Helpers::setting('nfSeparator'))); ?>

                                                </span>
                                            </li>
                                            <li class="mb-75">
                                                <?php if(Auth::user()->id == $user->id): ?>
                                                <a class="btn-sm btn-primary" href="<?php echo e(route('transaction.list')); ?>"><?php echo e(__('Transactions')); ?></a>
                                                <a class="btn btn-sm btn-warning me-1" data-bs-target="#transferUser" data-bs-toggle="modal" href="javascript:;"><?php echo e(__('Transfer')); ?></a>
                                                <?php if($user->role !== 'admin'): ?>
                                                <a class="btn btn-sm btn-success me-1" data-bs-target="#topupUser" data-bs-toggle="modal" href="javascript:;" id="topupbutton"><?php echo e(__('Top up')); ?></a>
                                                <?php endif; ?>
                                                <?php endif; ?>
                                            </li>
                                            <?php endif; ?>
                                            <li class="mb-75">
                                                <a class="btn btn-sm btn-primary me-1" data-bs-target="#editUser" data-bs-toggle="modal" href="javascript:;"><i data-feather="edit" class="me-0"></i> <?php echo e(__('Edit')); ?></a>
                                                <?php if($user->id > 4 && filter_var(\App\Helpers\Helpers::setting('allowUserDeleteAccount'), FILTER_VALIDATE_BOOLEAN)): ?>
                                                <a class="btn btn-sm btn-danger me-1" data-bs-target="#destroyUser" data-bs-toggle="modal" href="javascript:;"><i data-feather="trash" class="me-0"></i> <?php echo e(__('Delete Account')); ?></a>
                                                <?php endif; ?>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            </div>
                            <!-- /User Card -->
                        </div>
                        <!--/ User Sidebar -->

                        <!-- User Content -->
                        <?php if(\App\Helpers\Helpers::isEx() && $user->package->name !== 'super' && $user->role !== 'admin'): ?>
                        <div class="col-xl-4 col-lg-5 col-md-5 order-0 order-md-1">
                            <!-- Plan Card -->
                            <div class="card border-primary">
                                <div class="card-body">
                                    <span class="badge bg-light-primary"><?php echo e($user->package->name); ?></span>
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div class="d-flex justify-content-center">
                                            <sup class="h5 pricing-currency text-primary mt-1 mb-0"><?php echo e($currencyCode); ?></sup>
                                            <span class="fw-bolder display-6 mb-0 text-primary"><?php echo e(number_format($user->package->rate_monthly,\App\Helpers\Helpers::setting('nfDecimals'),\App\Helpers\Helpers::setting('nfDecimalpoint'),\App\Helpers\Helpers::setting('nfSeparator'))); ?></span>
                                            <sub class="pricing-duration font-small-4 ms-25 mt-auto mb-2">/<?php echo e(__('Month')); ?></sub>
                                        </div>
                                    </div>
                                    <!-- <div class="d-flex justify-content-between align-items-start">
                                        <div class="d-flex justify-content-center">
                                            <sup class="h5 pricing-currency text-primary mt-1 mb-0"><?php echo e($currencyCode); ?></sup>
                                            <span class="fw-bolder display-6 mb-0 text-primary"><?php echo e($user->package->rate_yearly); ?></span>
                                            <sub class="pricing-duration font-small-4 ms-25 mt-auto mb-2">/<?php echo e(__('Year')); ?></sub>
                                        </div>
                                    </div> -->
                                    <ul class="ps-1 mb-2">
                                        <li class="mb-50"><?php echo e(__('Outgoing')); ?>: <?php echo e($user->package->max_outgoing < 0 ? __('Unlimited') : number_format($user->package->max_outgoing,0,\App\Helpers\Helpers::setting('nfDecimalpoint'),\App\Helpers\Helpers::setting('nfSeparator'))); ?></li>
                                        <li class="mb-50"><?php echo e(__('Device')); ?>: <?php echo e($user->package->max_device < 0 ? __('Unlimited') : $user->package->max_device); ?></li>
                                        <li class="mb-50"><?php echo e(__('Autoreply Keyword')); ?>: <?php echo e($user->package->max_autoreply < 0 ? __('Unlimited') : $user->package->max_autoreply); ?></li>
                                        <li class="mb-50"><?php echo e(__('Phonebook')); ?>: <?php echo e($user->package->max_phonebook < 0 ? __('Unlimited') : $user->package->max_phonebook); ?></li>
                                        <li class="mb-50"><?php echo e(__('Webhook')); ?>: <?php echo e($user->package->webhook == 0 ? __('NO') : __('YES')); ?></li>
                                        <li class="mb-50"><?php echo e(__('Basic support')); ?></li>
                                    </ul>
                                    <?php if($daysRemaining <=3 && $walletBalance < $user->package->rate_monthly): ?>
                                    <p class="text-danger"><strong><?php echo e(__('Please top up wallet!')); ?></strong></p>
                                    <?php endif; ?>
                                    <?php if(round($daysUsed, 2) >= round($daysTotal, 2) || round($daysUsed, 2) < 0): ?>
                                    <div class="d-flex justify-content-between align-items-center fw-bolder mb-50">
                                        <span><?php echo e(__('Days')); ?></span>
                                        <span><?php echo e(round($daysTotal, 2) . ' of ' . round($daysTotal, 2) . ' ' . __('Days')); ?></span>
                                    </div>
                                    <?php else: ?>
                                    <div class="d-flex justify-content-between align-items-center fw-bolder mb-50">
                                        <span><?php echo e(__('Days')); ?></span>
                                        <span><?php echo e(round($daysUsed, 2) . ' of ' . round($daysTotal, 2) . ' ' . __('Days')); ?></span>
                                    </div>
                                    <?php endif; ?>
                                    <?php if($percentUsed < 0 || $percentUsed > 100): ?>
                                    <div class="progress mb-50" style="height: 16px">
                                        <div class="progress-bar" role="progressbar" style="width: 100%" aria-valuenow="65" aria-valuemax="100" aria-valuemin="80">100%</div>
                                    </div>
                                    <?php else: ?>
                                    <div class="progress mb-50" style="height: 16px">
                                        <div class="progress-bar" role="progressbar" style="width: <?php echo e($percentUsed); ?>%" aria-valuenow="65" aria-valuemax="100" aria-valuemin="80"><?php echo e($percentUsed); ?>%</div>
                                    </div>
                                    <?php endif; ?>
                                    <?php if(round($daysRemaining, 2) < 0): ?>
                                    <span><?php echo e('0 ' . __('days remaining')); ?></span>
                                    <?php else: ?>
                                    <span><?php echo e(round($daysRemaining, 2) . ' ' . __('days remaining')); ?></span>
                                    <?php endif; ?>
                                    <?php if(Auth::user()->role !== 'admin'): ?>
                                    <div class="d-grid w-100 mt-2">
                                        <a class="btn btn-primary me-1" data-bs-target="#upgradeUser" data-bs-toggle="modal" href="javascript:;">
                                            <?php echo e(__('Upgrade')); ?> / <?php echo e(__('Downgrade')); ?>

                                        </a>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                        <!--/ User Content -->
                    </div>
                </section>
                <!-- Update Avatar Modal starts-->
                <div class="modal fade" id="updateAvatar" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered modal-update-avatar">
                        <div class="modal-content">
                            <div class="modal-header bg-transparent">
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body pb-5 px-sm-5 pt-50">
                                <div class="text-center mb-2">
                                    <h1 class="mb-1"><?php echo e(__('Update avatar')); ?></h1>
                                </div>
                                <form action="<?php echo e(route('user.updateAvatar')); ?>" method="POST" class="row gy-1 pt-75" enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <div class="col-12">
                                        <label class="form-label" for="avatarPicture"><?php echo e(__('Avatar picture')); ?></label> <label class="form-label text-warning"> (JPG/JPEG/PNG | <?php echo e(__('Max')); ?> 2 MB | Ratio 1:1) </label>
                                        <input type="file" name="avatarPicture" class="form-control" />
                                        <input type="hidden"  name="user_id" value="<?php echo e($user->id); ?>" />
                                    </div>
                                    <div class="col-12 text-center mt-2 pt-50">
                                        <button type="submit" class="btn btn-primary me-1"><?php echo e(__('Submit')); ?></button>
                                        <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close"><?php echo e(__('Cancel')); ?></button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Update Avatar Modal Ends-->
                <!-- Edit User Modal -->
                <div class="modal fade" id="editUser" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog modal-xl modal-dialog-centered modal-edit-user">
                        <div class="modal-content">
                            <div class="modal-header bg-transparent">
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body pb-5 px-sm-5 pt-50">
                                <div class="text-center mb-2">
                                    <h1 class="mb-1"><?php echo e(__('Edit user form')); ?></h1>
                                </div>
                                <form action="<?php echo e(route('user.update')); ?>" method="POST" id="editUserForm" class="row gy-1 pt-75">
                                    <?php echo csrf_field(); ?>
                                    <div class="col-12 col-md-6">
                                        <input type="hidden"  name="user_id" value="<?php echo e($user->id); ?>" />
                                        <input type="hidden"  name="adminSender" value="<?php echo e($adminSender); ?>" />
                                        <label class="form-label" for="name"><?php echo e(__('Username')); ?></label>
                                        <input type="text" name="name" class="form-control" value="<?php echo e($user->name); ?>" required />
                                    </div>
                                    <div class="col-12 col-md-6">
                                        <label class="form-label" for="password"><?php echo e(__('Password minimum 6 characters')); ?></label>
                                        <input type="text" name="password" class="form-control" placeholder="<?php echo e(__('EMPTY = NO CHANGE')); ?>" />
                                    </div>
                                    <div class="col-12 col-md-6">
                                        <label class="form-label" for="email"><?php echo e(__('Email')); ?></label>
                                        <input type="text" name="email" class="form-control" value="<?php echo e($user->email); ?>" placeholder="example@domain.com" required />
                                    </div>
                                    <?php if($daysRemaining > 0 || $user->role === 'admin' || !\App\Helpers\Helpers::isEx()): ?>
                                    <div class="col-12 col-md-6">
                                        <label class="form-label" for="phone"><?php echo e(__('Phone')); ?></label>
                                        <input type="text" id="phone" name="phone" class="form-control" value="<?php echo e($user->phone); ?>" placeholder="6281212341234" required />
                                    </div>
                                    <?php if(filter_var(\App\Helpers\Helpers::setting('waVerification'), FILTER_VALIDATE_BOOLEAN) && Auth::user()->role !== 'admin' && !empty($adminSender)): ?>
                                    <div class="col-12 col-md-6">
                                        <button type="button" id="otpbutton_edit" class="btn btn-sm btn-primary"><?php echo e(__('Request OTP code')); ?></button>
                                        <input type="text" name="otp" class="form-control" placeholder="<?php echo e(__('Enter OTP')); ?>" required />
                                    </div>
                                    <?php endif; ?>
                                    <?php endif; ?>
                                    <div class="col-12 col-md-6">
                                        <label class="form-label" for="theme"><?php echo e(__('Panel theme')); ?></label>
                                        <select id="theme" name="theme" class="form-select">
                                            <option value="light-layout" <?php echo e(( $user->theme == 'light-layout' ) ? 'selected' : ''); ?>>Light theme</option>
                                            <option value="dark-layout" <?php echo e(( $user->theme == 'dark-layout' ) ? 'selected' : ''); ?>>Dark theme</option>
                                        </select>
                                    </div>
                                    <div class="col-12 col-md-6">
                                        <label class="form-label" for="rtl"><?php echo e(__('Text direction')); ?></label>
                                        <select name="rtl" class="form-select">
                                            <option value="0" <?php echo e(!$user->rtl ? 'selected' : ''); ?>>Left to Right (LTR)</option>
                                            <option value="1" <?php echo e($user->rtl ? 'selected' : ''); ?>>Right to Left (RTL)</option>
                                        </select>
                                    </div>
                                    <?php if(Auth::user()->role === 'admin' && $user->id > 3): ?>
                                    <div class="col-12 col-md-6">
                                        <label class="form-label" for="role"><?php echo e(__('User role')); ?></label>
                                        <select id="role" name="role" class="form-select">
                                            <option value="admin" <?php echo e(( $user->role === 'admin' ) ? 'selected' : ''); ?>>Admin</option>
                                            <option value="user" <?php echo e(( $user->role === 'user' ) ? 'selected' : ''); ?>>User</option>
                                        </select>
                                    </div>
                                    <div class="col-12 col-md-6">
                                        <label class="form-label" for="banned"><?php echo e(__('Ban')); ?>/<?php echo e(__('Unban User Account')); ?></label>
                                        <select name="banned" class="form-select">
                                            <option value="0" <?php echo e(!$user->banned ? 'selected' : ''); ?>><?php echo e(__('User Unbanned')); ?></option>
                                            <option value="1" <?php echo e($user->banned ? 'selected' : ''); ?>><?php echo e(__('User Banned')); ?></option>
                                        </select>
                                    </div>
                                    <div class="col-12 col-md-6" id="package" <?php echo e(\App\Helpers\Helpers::isEx()?'':'hidden'); ?>>
                                        <label class="form-label" for="package_name"><?php echo e(__('Package name')); ?></label>
                                        <select name="package_id" class="form-select">
                                            <option value="<?php echo e($user->package->id); ?>" selected><?php echo e($user->package->name . '-' . $user->package->rate_monthly . '/' . __('Month')); ?></option>
                                            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($package->id); ?>"><?php echo e($package->name . '-' . $package->rate_monthly . '/' . __('Month')); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <?php endif; ?>
                                    <div class="col-12 text-center mt-2 pt-50">
                                        <button type="submit" class="btn btn-primary me-1"><?php echo e(__('Submit')); ?></button>
                                        <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close"><?php echo e(__('Cancel')); ?></button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Delete Modal -->
                <div class="modal fade modal-danger text-start" id="destroyUser" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="myModalLabel120"><?php echo e(__('Delete confirmation')); ?></h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <?php echo e(__('Are you sure you want to delete?')); ?> <br><br>
                                <span class="text text-danger"> <b><?php echo e($user->name); ?></b> </span><br><br>
                                <?php echo e(__('This process is irreversible')); ?> <br>
                                <?php echo e(__('The record(s) will be deleted from the database permanently')); ?>

                            </div>
                            <div class="modal-footer">
                                <?php if(\App\Helpers\Helpers::isEx()): ?>
                                <?php echo e(__('WARNING! Wallet balance will be deleted after you click delete button')); ?>

                                <?php endif; ?>
                                <a class="btn btn-sm btn-danger" href="<?php echo e(route('user.destroySoft', ['user_id' => $user->id])); ?>"><?php echo e(__('Delete')); ?></a>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Modal -->
                <div class="modal fade" id="transferUser" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog modal-lg modal-dialog-centered modal-edit-user">
                        <div class="modal-content">
                            <div class="modal-header bg-transparent">
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body pb-5 px-sm-5 pt-50">
                                <div class="text-center mb-2">
                                    <h1 class="mb-1"><?php echo e(__('Transfer form')); ?></h1>
                                </div>
                                <form action="<?php echo e(route('transaction.transfer')); ?>" method="POST" id="transferUserForm" class="row gy-1 pt-75">
                                    <?php echo csrf_field(); ?>
                                    <div class="col-12 col-md-6">
                                        <input type="hidden"  name="adminSender" value="<?php echo e($adminSender); ?>" />
                                        <label class="form-label" for="from_name"><?php echo e(__('From')); ?></label>
                                        <input type="text" name="from_name" class="form-control" value="<?php echo e($user->name); ?>" placeholder="<?php echo e(__('Username')); ?>" required readonly />
                                    </div>
                                    <div class="col-12 col-md-6">
                                        <label class="form-label" for="to_name"><?php echo e(__('To')); ?></label>
                                        <?php if(Auth::user()->role === 'admin'): ?>
                                        <select class="select2 form-select" id="select2-basic" name="to_name">
                                            <optgroup label="Admins">
                                            <?php $__currentLoopData = $adminUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $adminUser): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($adminUser->id === $user->id || $adminUser->id == 2): ?> <?php continue; ?> <?php endif; ?>
                                                <option value="<?php echo e($adminUser->name); ?>"><?php echo e($adminUser->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </optgroup>
                                            <optgroup label="Users">
                                            <?php $__currentLoopData = $userUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $userUser): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($userUser->id === $user->id): ?> <?php continue; ?> <?php endif; ?>
                                                <option value="<?php echo e($userUser->name); ?>"><?php echo e($userUser->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </optgroup>
                                        </select>
                                        <?php else: ?>
                                        <input type="text" name="to_name" class="form-control" placeholder="<?php echo e(__('Enter recipient username')); ?>" required />
                                        <?php endif; ?>
                                    </div>
                                    <div class="col-12 col-md-6">
                                        <label class="form-label" for="amount"><?php echo e(__('Amount')); ?></label>
                                        <input type="number" name="amount" min="0.01" max="<?php echo e($user->role !== 'admin' ? $walletBalance : ''); ?>" step="0.01" class="form-control" required />
                                    </div>
                                    <div class="col-12 col-md-6">
                                        <label class="form-label" for="memo"><?php echo e(__('Memo')); ?></label> <label class="form-label text-warning"> (<?php echo e(__('Optional')); ?>)</label>
                                        <input type="text" name="memo" class="form-control" placeholder="<?php echo e(__('Enter a memo for this transfer')); ?>" />
                                    </div>
                                    <?php if(filter_var(\App\Helpers\Helpers::setting('waVerification'), FILTER_VALIDATE_BOOLEAN) && $user->role !== 'admin' && !empty($adminSender)): ?>
                                    <div class="col-12 col-md-6">
                                        <button type="button" id="otpbutton_transfer" class="btn btn-sm btn-primary"><?php echo e(__('Request OTP code')); ?></button>
                                        <input type="text" name="otp" class="form-control" placeholder="<?php echo e(__('Enter OTP')); ?>" required />
                                    </div>
                                    <?php endif; ?>
                                    <div class="col-12 text-center mt-2 pt-50">
                                        <button type="submit" class="btn btn-primary me-1"><?php echo e(__('Submit')); ?></button>
                                        <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close"><?php echo e(__('Cancel')); ?></button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Top up Modal -->
                <div class="modal fade" id="topupUser" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered modal-topup-user">
                        <div class="modal-content">
                            <div class="modal-header bg-transparent">
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body pb-5 px-sm-5 pt-50">
                                <div class="text-center mb-2">
                                    <h1 class="mb-1"><?php echo e(__('Top up form')); ?></h1>
                                </div>
                                <section class="app-user-view-security">
                                    <div class="card-body">
                                        <div class="card border-primary">
                                            <div class="card-body">
                                                <span class="badge bg-light-primary"><?php echo e(__('Top up value')); ?></span>
                                            </div>
                                            <form id="topupForm" action="<?php echo e(route('transaction.topup')); ?>" method="POST" enctype="multipart/form-data">
                                            <?php echo csrf_field(); ?>
                                                <input type="hidden" name="user_id" value="<?php echo e($user->id); ?>" />
                                                <input type="hidden" name="user_name" value="<?php echo e($user->name); ?>" />
                                                <input type="hidden" name="currencyCode" value="<?php echo e($currencyCode); ?>" />
                                                <div class="card-body">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="topupValue"><?php echo e(__('Top up value')); ?></label>
                                                        <div class="position-relative">
                                                            <?php if(\App\Helpers\Helpers::setting('topupValues')): ?>
                                                            <select name="topupValue" id="topupValue" class="form-select">
                                                                <?php $__currentLoopData = $topupValues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $topupValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($topupValue); ?>"><?php echo e($currencyCode); ?> <?php echo e(number_format($topupValue,\App\Helpers\Helpers::setting('nfDecimals'),\App\Helpers\Helpers::setting('nfDecimalpoint'),\App\Helpers\Helpers::setting('nfSeparator'))); ?></option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                            <?php else: ?>
                                                            <input type="number" name="topupValue" id="topupValue" step="0.01" class="form-control" required />
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                    <div class="mb-1">
                                                        <label class="form-label" for="gateway"><?php echo e(__('Pay with')); ?></label>
                                                        <div class="position-relative">
                                                            <select name="gateway" id="gateway" class="form-select">
                                                            <?php 
                                                            $firstOption = true;
                                                            
                                                            // Show module-based gateways first
                                                            foreach ($modules as $module) {
                                                              $name = $module->getLowerName();
                                                              if (config("$name.pg")) {
                                                                echo '<option value="' . $module->getName() . '">' . $module->getName() . '</option>';
                                                                $firstOption = false;
                                                              }
                                                            }
                                                            
                                                            // Show payment gateway table gateways
                                                            $offlineIsFirstOption = false;
                                                            foreach ($paymentGateways as $gateway) {
                                                                // Skip if already added from modules
                                                                $alreadyAdded = false;
                                                                foreach ($modules as $module) {
                                                                    if (strtolower($module->getName()) === strtolower($gateway->name)) {
                                                                        $alreadyAdded = true;
                                                                        break;
                                                                    }
                                                                }
                                                                if (!$alreadyAdded) {
                                                                    if ($gateway->name === 'offline') {
                                                                        // Make offline payment selected by default if it's the first option
                                                                        $selected = $firstOption ? ' selected' : '';
                                                                        if ($firstOption) $offlineIsFirstOption = true;
                                                                        echo '<option value="OfflinePayment"' . $selected . '>' . $gateway->display_name . '</option>';
                                                                    } else {
                                                                        echo '<option value="' . $gateway->name . '">' . $gateway->display_name . '</option>';
                                                                    }
                                                                    $firstOption = false;
                                                                }
                                                            }
                                                            ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="mb-1" id="gopayId" style="display: none;">
                                                        <label class="form-label" for="userGopayId">Gopay ID anda (contoh: 081212341234)</label>
                                                        <div class="position-relative">
                                                            <input type="text" name="userGopayId" class="form-control" />
                                                        </div>
                                                    </div>
                                                    
                                                    <!-- Offline Payment Details -->
                                                    <div id="offlinePaymentDetails" style="display: <?php echo $offlineIsFirstOption ? 'block' : 'none'; ?>;">
                                                        <?php
                                                            $offlineGateway = \App\Models\PaymentGateway::where('name', 'offline')->first();
                                                            $offlineSettings = $offlineGateway->settings ?? [];
                                                        ?>
                                                        <div class="alert alert-info">
                                                            <h5 class="alert-heading"><i data-feather="info"></i> <?php echo e(__('Payment Instructions')); ?></h5>
                                                            <p class="mb-1"><strong><?php echo e(__('Bank Name')); ?>:</strong> <?php echo e($offlineSettings['bank_name'] ?? 'Not configured'); ?></p>
                                                            <p class="mb-1"><strong><?php echo e(__('Account Number')); ?>:</strong> <span class="badge bg-primary"><?php echo e($offlineSettings['account_number'] ?? 'Not configured'); ?></span></p>
                                                            <p class="mb-1"><strong><?php echo e(__('Account Name')); ?>:</strong> <?php echo e($offlineSettings['account_name'] ?? 'Not configured'); ?></p>
                                                            <p class="mb-1"><strong><?php echo e(__('Amount to Pay')); ?>:</strong> <span id="displayAmount" class="text-primary fw-bold"><?php echo e($currencyCode); ?> 0.00</span></p>
                                                            <hr>
                                                            <p class="mb-0"><small><?php echo e($offlineSettings['instructions'] ?? 'Please make payment to the above account and upload proof of payment. Your wallet will be credited after admin approval.'); ?></small></p>
                                                        </div>
                                                        
                                                        <?php if(($offlineSettings['require_proof'] ?? 1)): ?>
                                                        <div class="mb-1">
                                                            <label class="form-label" for="proof_of_payment">
                                                                <i data-feather="upload"></i> <?php echo e(__('Proof of Payment')); ?> <span class="text-danger">*</span>
                                                            </label>
                                                            <input type="file" name="proof_of_payment" id="proof_of_payment" class="form-control" accept="image/jpeg,image/jpg,image/png,image/gif,application/pdf" />
                                                            <small class="text-muted">
                                                                <i data-feather="alert-circle" class="text-warning" style="width: 14px; height: 14px;"></i>
                                                                <?php echo e(__('Upload screenshot or PDF of payment receipt (Max: 5MB)')); ?>

                                                            </small>
                                                            <div id="file-preview" class="mt-1" style="display: none;">
                                                                <span class="badge bg-success"><i data-feather="check"></i> <span id="file-name"></span></span>
                                                            </div>
                                                        </div>
                                                        <?php endif; ?>
                                                        
                                                        <div class="mb-1">
                                                            <label class="form-label" for="reference">
                                                                <i data-feather="file-text"></i> <?php echo e(__('Reference/Notes')); ?>

                                                            </label>
                                                            <textarea name="reference" id="reference" class="form-control" rows="2" placeholder="<?php echo e(__('Optional: Add transaction reference or notes (e.g., bank transfer reference number)')); ?>"></textarea>
                                                            <small class="text-muted"><?php echo e(__('This helps admin verify your payment faster')); ?></small>
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="mb-1">
                                                        <button class="btn btn-primary btn-page-block-custom waves-effect" type="submit">
                                                            <?php echo e(__('Top up')); ?>

                                                        </button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </section>
                            </div>
                        </div>
                    </div>
                </div>
                
                <script>
                $(document).ready(function() {
                    function handleGatewayChange() {
                        var selectedGateway = $('#gateway').val();
                        console.log('Selected gateway:', selectedGateway); // Debug log
                        
                        if (selectedGateway === 'OfflinePayment') {
                            $('#offlinePaymentDetails').show();
                            $('#gopayId').hide();
                            $('#proof_of_payment').prop('required', true);
                            $('#proof_of_payment').prop('disabled', false);
                            updateDisplayAmount();
                        } else {
                            $('#offlinePaymentDetails').hide();
                            $('#gopayId').toggle(selectedGateway === 'Gopay');
                            $('#proof_of_payment').prop('required', false);
                            $('#proof_of_payment').prop('disabled', true);
                            $('#proof_of_payment').val(''); // Clear any selected file
                            $('#reference').val(''); // Clear reference field
                        }
                    }
                    
                    // Handle gateway selection
                    $('#gateway').on('change', handleGatewayChange);
                    
                    // Handle amount changes (both change and input events for real-time update)
                    $('#topupValue').on('change input', function() {
                        updateDisplayAmount();
                    });
                    
                    // Handle file selection - show file name and validate
                    $('#proof_of_payment').on('change', function() {
                        var fileName = $(this).val().split('\\').pop();
                        var fileSize = this.files[0]?.size || 0;
                        var maxSize = 5 * 1024 * 1024; // 5MB
                        
                        if (fileSize > maxSize) {
                            alert('<?php echo e(__("File size must be less than 5MB")); ?>');
                            $(this).val('');
                            $('#file-preview').hide();
                            return;
                        }
                        
                        if (fileName) {
                            console.log('Proof file selected:', fileName);
                            $('#file-name').text(fileName);
                            $('#file-preview').show();
                            feather.replace(); // Re-initialize feather icons
                        } else {
                            $('#file-preview').hide();
                        }
                    });
                    
                    // Form submission validation
                    $('#topupForm').on('submit', function(e) {
                        var selectedGateway = $('#gateway').val();
                        
                        if (selectedGateway === 'OfflinePayment') {
                            var proofFile = $('#proof_of_payment')[0].files[0];
                            
                            if (!proofFile) {
                                e.preventDefault();
                                alert('<?php echo e(__("Please upload proof of payment")); ?>');
                                $('#proof_of_payment').focus();
                                return false;
                            }
                            
                            // Validate file type
                            var allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif', 'application/pdf'];
                            if (!allowedTypes.includes(proofFile.type)) {
                                e.preventDefault();
                                alert('<?php echo e(__("Please upload a valid image (JPEG, PNG, GIF) or PDF file")); ?>');
                                $('#proof_of_payment').focus();
                                return false;
                            }
                        }
                        
                        // Show loading state
                        $(this).find('button[type="submit"]').prop('disabled', true).html('<span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span><?php echo e(__("Processing...")); ?>');
                    });
                    
                    function updateDisplayAmount() {
                        var amount = $('#topupValue').val();
                        if (amount) {
                            var currencyCode = '<?php echo e($currencyCode); ?>';
                            var decimals = <?php echo e(\App\Helpers\Helpers::setting('nfDecimals') ?? 2); ?>;
                            var decimalPoint = '<?php echo e(\App\Helpers\Helpers::setting('nfDecimalpoint') ?? '.'); ?>';
                            var separator = '<?php echo e(\App\Helpers\Helpers::setting('nfSeparator') ?? ','); ?>';
                            
                            var formattedAmount = parseFloat(amount).toFixed(decimals);
                            formattedAmount = formattedAmount.replace('.', decimalPoint);
                            
                            $('#displayAmount').text(currencyCode + ' ' + formattedAmount);
                        }
                    }
                    
                    // Trigger initial state on page load
                    handleGatewayChange();
                    
                    // Initialize display amount on page load
                    updateDisplayAmount();
                    
                    // Initialize feather icons if present
                    if (typeof feather !== 'undefined') {
                        feather.replace();
                    }
                    
                    // Debug: Log initial state
                    console.log('Offline section visible:', $('#offlinePaymentDetails').is(':visible'));
                    console.log('Proof field enabled:', !$('#proof_of_payment').prop('disabled'));
                });
                </script>

                <!-- upgrade your plan Modal -->
                <div class="modal fade" id="upgradeUser" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog modal-lg modal-dialog-centered modal-upgrade-user">
                        <div class="modal-content">
                            <div class="modal-header bg-transparent">
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body pb-5 px-sm-5 pt-50">
                                <div class="text-center mb-2">
                                    <h1 class="mb-1"><?php echo e(__('Upgrade form')); ?></h1>
                                </div>
                                <section class="app-user-view-security">
                                    <div class="card-body">
                                        <div class="card border-primary">
                                            <div class="card-body">
                                                <div class="row">
                                                <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-4">
                                                    <span class="badge bg-light-primary"><strong><?php echo e($package->name); ?></strong></span>
                                                    <ul class="ps-1 mb-2">
                                                        <li class="mb-50"><?php echo e(__('Outgoing')); ?>: <?php echo e($package->max_outgoing < 0 ? __('Unlimited') : number_format($package->max_outgoing,0,\App\Helpers\Helpers::setting('nfDecimalpoint'),\App\Helpers\Helpers::setting('nfSeparator'))); ?></li>
                                                        <li class="mb-50"><?php echo e(__('Device')); ?>: <?php echo e($package->max_device < 0 ? __('Unlimited') : $package->max_device); ?></li>
                                                        <li class="mb-50"><?php echo e(__('Autoreply Keyword')); ?>: <?php echo e($package->max_autoreply < 0 ? __('Unlimited') : $package->max_autoreply); ?></li>
                                                        <li class="mb-50"><?php echo e(__('Phonebook')); ?>: <?php echo e($package->max_phonebook < 0 ? __('Unlimited') : $package->max_phonebook); ?></li>
                                                        <li class="mb-50"><?php echo e(__('Webhook')); ?>: <?php echo e($package->webhook == 0 ? __('NO') : __('YES')); ?></li>
                                                        <li class="mb-50"><b><?php echo e(__('Monthly')); ?>: <?php echo e(number_format($package->rate_monthly,\App\Helpers\Helpers::setting('nfDecimals'),\App\Helpers\Helpers::setting('nfDecimalpoint'),\App\Helpers\Helpers::setting('nfSeparator'))); ?></b></li>
                                                        <!-- <li class="mb-50"><?php echo e(__('Yearly')); ?>: <?php echo e($currencyCode); ?> <?php echo e($package->rate_yearly); ?></li> -->
                                                    </ul>
                                                </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            </div>
                                            <form action="<?php echo e(route('transaction.upgrade')); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                                <input type="hidden" name="user_id" value="<?php echo e($user->id); ?>" />
                                                <input type="hidden" name="user_name" value="<?php echo e($user->name); ?>" />
                                                <input type="hidden" name="currencyCode" value="<?php echo e($currencyCode); ?>" />
                                                <input type="hidden" name="walletBalance" value="<?php echo e($walletBalance); ?>" />
                                                <div class="card-body">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="choosePackage"><?php echo e(__('Choose package')); ?></label>
                                                        <div class="position-relative">
                                                            <select name="package_id" class="form-select">
                                                                <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($package->id); ?>"><?php echo e($package->name); ?></option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="mb-1" hidden>
                                                        <label class="form-label" for="chooseInterval"><?php echo e(__('Choose interval')); ?></label>
                                                        <div class="position-relative">
                                                            <select name="billing_interval" class="form-select">
                                                                <?php $__currentLoopData = $intervals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $interval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($interval); ?>"><?php echo e($interval); ?></option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="mb-1">
                                                        <label class="form-label" for="balance"><?php echo e(__('Wallet balance')); ?>: </label>
                                                        <?php if($walletBalance < 0): ?>
                                                        <span class="badge rounded-pill badge-light-danger me-1">
                                                        <?php else: ?>
                                                        <span class="badge rounded-pill badge-light-success me-1">
                                                        <?php endif; ?>
                                                        <?php echo e(number_format($walletBalance,\App\Helpers\Helpers::setting('nfDecimals'),\App\Helpers\Helpers::setting('nfDecimalpoint'),\App\Helpers\Helpers::setting('nfSeparator'))); ?>

                                                        </span>
                                                    </div>
                                                    <div class="mb-1">
                                                        <span class="badge bg-light-warning"><strong><?php echo e(__('Upgrade will be charged at a pro-rated amount from today until the end of month')); ?></strong></span>
                                                        <span class="badge bg-light-warning"><strong><?php echo e(__('Downgrade will be free. New rate will affect at the beginning of next month')); ?></strong></span>
                                                    </div>
                                                    <div class="mb-1">
                                                        <button class="btn btn-primary btn-page-block-custom waves-effect" type="submit">
                                                            <?php echo e(__('Upgrade / Downgrade')); ?>

                                                        </button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </section>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- END: Content-->

    <!-- BEGIN: Vendor JS-->
    <script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/vendors.min.js"></script>
    <!-- BEGIN Vendor JS-->

    <!-- BEGIN: Page Vendor JS-->
    <script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/forms/select/select2.full.min.js"></script>
    <!-- END: Page Vendor JS-->

    <!-- BEGIN: Page JS-->
    <script src="<?php echo e(url('/')); ?>/app-assets/js/scripts/forms/form-select2.js"></script>
    <!-- END: Page JS-->

    <script>
    $(document).ready(function(){
        if ($('#gateway').val() === 'Gopay') {
            $('#gopayId').show();
        } else {
            $('#gopayId').hide();
        }
        if ($('#role').val() === 'admin') {
            $("#package").hide();
        }
    });

    $('#role').change(function() {
        $("#package").toggle(this.value !== 'admin');
    })

    $('#gateway').change(function(e) {
        e.preventDefault();
        $("#gopayId").toggle(this.value === 'Gopay');
    });

    $("#otpbutton_edit").click(function(e) {
        e.preventDefault();
        $.ajax({
            type:"get",
            url: '<?php echo e(route('user.otpSend')); ?>',
            data: {adminSender: '<?php echo e($adminSender); ?>', phone: $("#phone").val(), name: '<?php echo e($user->name); ?>', msgOtp: '_MsgOtpEdit'},
            success: $("#otpbutton_edit").prop("disabled",true),
        });
        var text = $("#otpbutton_edit").html();
        var count = 60;
        var counter = setInterval(timer, 1000);
        function timer(){
            count -= 1;
            if (count <= 0){
                clearInterval(counter);
                $("#otpbutton_edit").html(text);
                $("#otpbutton_edit").prop("disabled",false);
                return;
            }
            $("#otpbutton_edit").html(text + ' in ' + count + " seconds.");
        }
    });

    $("#otpbutton_transfer").click(function(e) {
        e.preventDefault();
        $.ajax({
            type:"get",
            url: '<?php echo e(route('user.otpSend')); ?>',
            data: {adminSender: '<?php echo e($adminSender); ?>', phone: '<?php echo e($user->phone); ?>', name: '<?php echo e($user->name); ?>', msgOtp: '_MsgOtpTransfer'},
            success: $("#otpbutton_transfer").prop("disabled",true),
        });
        var text = $("#otpbutton_transfer").html();
        var count = 60;
        var counter = setInterval(timer, 1000);
        function timer(){
            count -= 1;
            if (count <= 0){
                clearInterval(counter);
                $("#otpbutton_transfer").html(text);
                $("#otpbutton_transfer").prop("disabled",false);
                return;
            }
            $("#otpbutton_transfer").html(text + ' in ' + count + " seconds.");
        }
    });
    </script>

<?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home/procharmate/public_html/whatsapp.procharmate.com/resources/views//user-show.blade.php ENDPATH**/ ?>