<!DOCTYPE html>
<?php if(auth()->guard()->check()): ?>
<?php
App::setLocale(Auth::user()->lang);
?>
<html class="loading <?php echo e(Auth::user()->theme); ?>" lang="<?php echo e(Auth::user()->lang); ?>" data-textdirection="ltr">
<?php elseif(auth()->guard()->guest()): ?>
<html class="loading light-layout" lang="us" data-textdirection="ltr">
<?php endif; ?>
<!-- BEGIN: Head-->

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1.0,user-scalable=0,minimal-ui">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="description" content="NearBuyMarts Whatsapp Gateway simple but powerful, handles complex tasks, clean and easy to read codes.">
    <meta name="keywords" content="NearBuyMarts whatsapp gateway, multi device, baileys, multi sessions, multi users">
    <meta name="author" content="NearBuyMarts">
    <title><?php echo e(config('app.name')); ?></title>
    <link rel="apple-touch-icon" href="<?php echo e(url('/')); ?>/app-assets/images/ico/apple-icon-120.png">
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(url('/')); ?>/app-assets/images/ico/favicon.ico">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,300;0,400;0,500;0,600;1,400;1,500;1,600">
    <link rel="stylesheet" href="<?php echo e(url('/')); ?>/app-assets/fonts/font-awesome/css/font-awesome.min.css">

    <!-- BEGIN: Vendor CSS-->
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/vendors/css/vendors.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/vendors/css/forms/select/select2.min.css">
    <!-- <link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/vendors/css/tables/datatable/dataTables.bootstrap5.min.css"> -->
    <!-- END: Vendor CSS-->

    <!-- BEGIN: Theme CSS-->
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/css<?php echo e(Auth::user() && Auth::user()->rtl ? '-rtl':''); ?>/bootstrap.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/css<?php echo e(Auth::user() && Auth::user()->rtl ? '-rtl':''); ?>/bootstrap-extended.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/css<?php echo e(Auth::user() && Auth::user()->rtl ? '-rtl':''); ?>/colors.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/css<?php echo e(Auth::user() && Auth::user()->rtl ? '-rtl':''); ?>/components.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/css<?php echo e(Auth::user() && Auth::user()->rtl ? '-rtl':''); ?>/themes/dark-layout.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/css<?php echo e(Auth::user() && Auth::user()->rtl ? '-rtl':''); ?>/themes/bordered-layout.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/css<?php echo e(Auth::user() && Auth::user()->rtl ? '-rtl':''); ?>/themes/semi-dark-layout.css">

    <!-- BEGIN: Page CSS-->
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/css<?php echo e(Auth::user() && Auth::user()->rtl ? '-rtl':''); ?>/core/menu/menu-types/vertical-menu.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/css<?php echo e(Auth::user() && Auth::user()->rtl ? '-rtl':''); ?>/plugins/forms/form-validation.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/css<?php echo e(Auth::user() && Auth::user()->rtl ? '-rtl':''); ?>/plugins/extensions/ext-component-toastr.css">
    <!-- END: Page CSS-->

    <!-- BEGIN: Custom CSS-->
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/assets/css/style.css">
    <!-- END: Custom CSS-->

    <script async src="https://www.googletagmanager.com/gtag/js?id=G-HTN5RP4CBJ"></script>
    <script>
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    gtag('js', new Date());

    gtag('config', 'G-HTN5RP4CBJ');
    </script>
</head>
<!-- END: Head-->

<!-- BEGIN: Body-->

<body class="vertical-layout vertical-menu-modern navbar-floating footer-static" data-open="click" data-menu="vertical-menu-modern" data-col="">
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-5KG4ZNG"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>

    <!-- BEGIN: Header-->
    <nav class="header-navbar navbar navbar-expand-lg align-items-center floating-nav navbar-light navbar-shadow">
        <div class="navbar-container d-flex content">
            <ul class="nav navbar-nav d-xl-none">
                <li class="nav-item"><a class="nav-link menu-toggle" href="#"><i class="ficon" data-feather="menu"></i></a></li>
            </ul>
            <?php if(auth()->guard()->check()): ?>
            <!-- BEGIN: Alert -->
            <?php if(Session::has('success_alert')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <div class="alert-body"><?php echo Session::get('success_alert'); ?></div>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php elseif(Session::has('danger_alert')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <div class="alert-body"><?php echo Session::get('danger_alert'); ?></div>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php endif; ?>
            <?php if($errors->any()): ?>
            <div class="alert alert-danger" alert-dismissible fade show role="alert">
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php endif; ?>
            <!-- END: Alert -->

            <ul class="nav navbar-nav align-items-center ms-auto">
                <li class="nav-item impersonate">
                    <?php if (is_impersonating($guard = null)) : ?>
                    <a class="btn btn-warning" href="<?php echo e(route('user.leaveImpersonate')); ?>">ADMIN</a>
                    <?php endif; ?>
                </li>
                <?php if(\App\Helpers\Helpers::isEx()): ?>
                <li>
                    <a href="<?php echo e(route('transaction.list')); ?>">
                        <i class="fas fa-wallet"></i>
                        <?php if(Auth::user()->transactions()->sum('amount') < 0 ): ?>
                        <span class="badge rounded-pill badge-light-danger me-1">
                        <?php else: ?>
                        <span class="badge rounded-pill badge-light-success me-1">
                        <?php endif; ?>
                            <?php echo e(\App\Helpers\Helpers::setting('currencyCode')); ?> <?php echo e(number_format(Auth::user()->transactions()->sum('amount'),\App\Helpers\Helpers::setting('nfDecimals'),\App\Helpers\Helpers::setting('nfDecimalpoint'),\App\Helpers\Helpers::setting('nfSeparator'))); ?>

                        </span>
                    </a>
                </li>
                <?php endif; ?>
                <li class="nav-item dropdown dropdown-language"><a class="nav-link dropdown-toggle" id="dropdown-flag" href="#" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="flag-icon flag-icon-<?php echo e(Auth::user()->lang); ?>"></i><span class="selected-language"><?php echo e(Auth::user()->lang); ?></span></a>
                    <div class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdown-flag">
                        <?php $__currentLoopData = glob(base_path() . '/lang/*.json'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $locale = pathinfo($file, PATHINFO_FILENAME); ?>
                        <a class="dropdown-item" href="<?php echo e(route('user.locale', ['locale' => $locale])); ?>" data-language="<?php echo e($locale); ?>">
                            <i class="flag-icon flag-icon-<?php echo e($locale); ?>"></i>
                            <?php echo e($locale); ?>

                        </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </li>
                <li class="nav-item dropdown dropdown-user">
                    <a class="nav-link dropdown-toggle dropdown-user-link" id="dropdown-user" href="#" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <div class="user-nav d-sm-flex d-none">
                            <span class="user-name fw-bolder"><?php echo e(ucwords(str_replace('_',' ', Auth::user()->name))); ?></span>
                            <span class="user-status"><?php echo e(App\Models\Package::where('id', Auth::user()->package_id)->value('name')); ?></span>
                        </div>
                        <span class="avatar">
                            <img class="round" src="<?php echo e(\App\Helpers\Helpers::avatarUrl()); ?>" alt="avatar" height="40" width="40">
                            <span class="avatar-status-online"></span>
                        </span>
                    </a>
                    <div class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdown-user">
                        <a class="dropdown-item" href="<?php echo e(route('user.show', ['user_id' => Auth::user()->id])); ?>">
                            <i class="me-50" data-feather="user"></i> <?php echo e(__('My account')); ?>

                        </a>
                        <?php if(Auth::check()): ?>
                        <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                            onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                            <i class="me-50" data-feather="power"></i> <?php echo e(__('Log out')); ?>

                        </a>
                        <form method="POST" id="logout-form" action="<?php echo e(route('logout')); ?>">
                            <?php echo csrf_field(); ?>
                        </form>
                        <?php else: ?>
                        <a class="dropdown-item" href="<?php echo e(Route::has('login') ? route('login') : 'javascript:void(0)'); ?>">
                            <i class="me-50" data-feather="log-in"></i> <?php echo e(__('Log in')); ?>

                        </a>
                        <?php endif; ?>
                    </div>
                </li>
            </ul>
            <?php endif; ?>
        </div>
    </nav>
    
    <!-- END: Header-->

    <!-- BEGIN: Main Menu-->
    <div class="main-menu menu-fixed menu-light menu-accordion menu-shadow" data-scroll-to-active="true">
        <div class="navbar-header">
            <ul class="nav navbar-nav flex-row">
                <li class="nav-item me-auto">
                    <a class="navbar-brand" href="<?php echo e(url('/')); ?>">
                        <?php if(\App\Helpers\Helpers::setting('logoUrl')): ?>
                        <span class="brand-logo">
                            <img src="<?php echo e(\App\Helpers\Helpers::setting('logoUrl')); ?>" style="max-width: 200px; height: auto; max-height: 40px;">
                        </span>
                        <?php else: ?>
                        <h2 class="brand-text"><?php echo e(config('app.name')); ?></h2>
                        <?php endif; ?>
                    </a></li>
                <li class="nav-item nav-toggle"><a class="nav-link modern-nav-toggle pe-0" data-bs-toggle="collapse"><i class="d-block d-xl-none text-primary toggle-icon font-medium-4" data-feather="x"></i><i class="d-none d-xl-block collapse-toggle-icon font-medium-4  text-primary" data-feather="disc" data-ticon="disc"></i></a></li>
            </ul>
        </div>
        <div class="shadow-bottom"></div>
        <?php
        $installedVersion = file_get_contents(base_path('storage/installed'));
        $latestVersion = file_exists(base_path('storage/latest')) ? file_get_contents(base_path('storage/latest')) : $installedVersion;
        ?>
        <div class="main-menu-content">
            <?php if(auth()->guard()->check()): ?>
            <?php ($adminSender = \App\Models\Device::where('user_id', 1)->where('status', '=', 'ONLINE')->value('sender')); ?>
            <?php if(empty(Auth::user()->banned) && (empty($adminSender) || !empty(Auth::user()->email_verified_at) || !filter_var(\App\Helpers\Helpers::setting('waVerification'), FILTER_VALIDATE_BOOLEAN))): ?>
            <ul class="navigation navigation-main" id="main-menu-navigation" data-menu="menu-navigation">
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'user.show' ? 'active' : ''); ?>" id="user.show"><a class="d-flex align-items-center" href="<?php echo e(route('user.show', ['user_id' => Auth::user()->id])); ?>"><i data-feather="user"></i><span class="menu-item text-truncate"><?php echo e(__('My account')); ?></span></a></li>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'device.list' ? 'active' : ''); ?>" id="device.list"><a class="d-flex align-items-center" href="<?php echo e(route('device.list')); ?>"><i data-feather="smartphone"></i><span class="menu-item text-truncate"><?php echo e(__('Devices')); ?></span><span class="badge badge-light-primary rounded-pill ms-auto me-1"><?php echo e(DB::table('devices')->where('user_id', '=', Auth::user()->id)->count()); ?></span></a></li>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'sendmsg.index' ? 'active' : ''); ?>" id="sendmsg.index"><a class="d-flex align-items-center" href="<?php echo e(route('sendmsg.index')); ?>"><i data-feather="send"></i><span class="menu-item text-truncate"><?php echo e(__('Send message')); ?></span></a></li>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'autoreply.list' ? 'active' : ''); ?>" id="autoreply.list"><a class="d-flex align-items-center" href="<?php echo e(route('autoreply.list')); ?>"><i data-feather="repeat"></i><span class="menu-item text-truncate"><?php echo e(__('Autoreply')); ?></span></a></li>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'outbox.list' ? 'active' : ''); ?>" id="outbox.list"><a class="d-flex align-items-center" href="<?php echo e(route('outbox.list')); ?>"><i data-feather="external-link"></i><span class="menu-item text-truncate"><?php echo e(__('Outbox')); ?></span></a></li>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'outbox.listRecurring' ? 'active' : ''); ?>" id="outbox.listRecurring"><a class="d-flex align-items-center" href="<?php echo e(route('outbox.listRecurring')); ?>"><i data-feather="clock"></i><span class="menu-item text-truncate"><?php echo e(__('Recurring')); ?></span></a></li>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'phonebook.list' ? 'active' : ''); ?>" id="phonebook.list"><a class="d-flex align-items-center" href="<?php echo e(route('phonebook.list')); ?>"><i data-feather="book-open"></i><span class="menu-item text-truncate"><?php echo e(__('Phonebooks')); ?></span></a></li>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'template.list' ? 'active' : ''); ?>" id="template.list"><a class="d-flex align-items-center" href="<?php echo e(route('template.list')); ?>"><i data-feather="clipboard"></i><span class="menu-item text-truncate"><?php echo e(__('Templates')); ?></span></a></li>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'capture.list' ? 'active' : ''); ?>" id="capture.list"><a class="d-flex align-items-center" href="<?php echo e(route('capture.list')); ?>"><i data-feather="save"></i><span class="menu-item text-truncate"><?php echo e(__('Captures')); ?></span></a></li>
                <?php if(env('RECORD_MESSAGES')): ?>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'message.list' ? 'active' : ''); ?>" id="message.list"><a class="d-flex align-items-center" href="<?php echo e(route('message.list')); ?>"><i data-feather="message-square"></i><span class="menu-item text-truncate"><?php echo e(__('Messages')); ?></span></a></li>
                <?php endif; ?>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'subscriber.list' ? 'active' : ''); ?>" id="subscriber.list"><a class="d-flex align-items-center" href="<?php echo e(route('subscriber.list')); ?>"><i data-feather="user-plus"></i><span class="menu-item text-truncate"><?php echo e(__('Subscribers')); ?></span></a></li>
                <li class="navigation-header"><span><?php echo e(__('Management')); ?></span><i data-feather="more-horizontal"></i></li>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'todo.list' ? 'active' : ''); ?>" id="todo.list"><a class="d-flex align-items-center" href="<?php echo e(route('todo.list')); ?>"><i data-feather="check-square"></i><span class="menu-item text-truncate"><?php echo e(__('Todos')); ?></span><span class="badge badge-light-warning rounded-pill ms-auto me-1"><?php echo e(\App\Models\Todo::where('user_id', Auth::user()->id)->pending()->count()); ?></span></a></li>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'invoice.list' ? 'active' : ''); ?>" id="invoice.list"><a class="d-flex align-items-center" href="<?php echo e(route('invoice.list')); ?>"><i data-feather="file-text"></i><span class="menu-item text-truncate"><?php echo e(__('Invoices')); ?></span></a></li>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'transaction.list' ? 'active' : ''); ?>" id="transaction.list"><a class="d-flex align-items-center" href="<?php echo e(route('transaction.list')); ?>"><i data-feather="dollar-sign"></i><span class="menu-item text-truncate"><?php echo e(__('Transactions')); ?></span></a></li>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'chatbot.list' ? 'active' : ''); ?>" id="chatbot.list"><a class="d-flex align-items-center" href="<?php echo e(route('chatbot.list')); ?>"><i data-feather="message-circle"></i><span class="menu-item text-truncate"><?php echo e(__('Chatbot')); ?></span></a></li>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'variable.list' ? 'active' : ''); ?>" id="variable.list"><a class="d-flex align-items-center" href="<?php echo e(route('variable.list')); ?>"><i data-feather="code"></i><span class="menu-item text-truncate"><?php echo e(__('Variables')); ?></span></a></li>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'notification.index' ? 'active' : ''); ?>" id="notification.index"><a class="d-flex align-items-center" href="<?php echo e(route('notification.index')); ?>"><i data-feather="bell"></i><span class="menu-item text-truncate"><?php echo e(__('Notifications')); ?></span><?php if(Auth::user()->unreadNotifications->count() > 0): ?><span class="badge badge-light-danger rounded-pill ms-auto me-1"><?php echo e(Auth::user()->unreadNotifications->count()); ?></span><?php endif; ?></a></li>
                <li class="navigation-header"><span><?php echo e(__('Support')); ?></span><i data-feather="more-horizontal"></i></li>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && str_starts_with($_COOKIE['active_menu'], 'support.tickets') ? 'active' : ''); ?>" id="support.tickets"><a class="d-flex align-items-center" href="<?php echo e(route('support.tickets.index')); ?>"><i data-feather="inbox"></i><span class="menu-item text-truncate"><?php echo e(__('Tickets')); ?></span><?php ($pendingTickets = \App\Models\SupportTicket::where('device_id', session('device_id'))->whereIn('status', ['new', 'open'])->count()); ?><?php if($pendingTickets > 0): ?><span class="badge badge-light-warning rounded-pill ms-auto me-1"><?php echo e($pendingTickets); ?></span><?php endif; ?></a></li>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && str_starts_with($_COOKIE['active_menu'], 'support.agents') ? 'active' : ''); ?>" id="support.agents"><a class="d-flex align-items-center" href="<?php echo e(route('support.agents.index')); ?>"><i data-feather="headphones"></i><span class="menu-item text-truncate"><?php echo e(__('Agents')); ?></span></a></li>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && str_starts_with($_COOKIE['active_menu'], 'staff') ? 'active' : ''); ?>" id="staff"><a class="d-flex align-items-center" href="<?php echo e(route('staff.index')); ?>"><i data-feather="users"></i><span class="menu-item text-truncate"><?php echo e(__('Staff')); ?></span></a></li>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && str_starts_with($_COOKIE['active_menu'], 'support.leads') ? 'active' : ''); ?>" id="support.leads"><a class="d-flex align-items-center" href="<?php echo e(route('support.leads.index')); ?>"><i data-feather="target"></i><span class="menu-item text-truncate"><?php echo e(__('Leads')); ?></span><?php ($newLeads = \App\Models\Lead::where('device_id', session('device_id'))->where('status', 'new')->count()); ?><?php if($newLeads > 0): ?><span class="badge badge-light-info rounded-pill ms-auto me-1"><?php echo e($newLeads); ?></span><?php endif; ?></a></li>
                <li class="navigation-header"><span><?php echo e(__('Integrations')); ?></span><i data-feather="more-horizontal"></i></li>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && str_starts_with($_COOKIE['active_menu'], 'api.') ? 'active' : ''); ?>" id="api.tokens"><a class="d-flex align-items-center" href="<?php echo e(route('api.tokens.index')); ?>"><i data-feather="key"></i><span class="menu-item text-truncate"><?php echo e(__('API Tokens')); ?></span></a></li>
                <li class="navigation-header"><span><?php echo e(__('System')); ?></span><i data-feather="more-horizontal"></i></li>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'restapi.index' ? 'active' : ''); ?>" id="restapi.index"><a class="d-flex align-items-center" href="<?php echo e(route('restapi.index')); ?>"><i data-feather="zap"></i><span class="menu-item text-truncate"><?php echo e(__('Rest API')); ?></span></a></li>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'documentations' ? 'active' : ''); ?>" id="documentations"><a class="d-flex align-items-center" href="<?php echo e(route('documentations')); ?>"><i data-feather="life-buoy"></i><span class="menu-item text-truncate"><?php echo e(__('Documentations')); ?></span></a></li>
                <?php if(Auth::user()->role === 'admin'): ?>
                <li class="navigation-header"><span>Admin Access</span><i data-feather="more-horizontal"></i></li>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'transaction.listOffline' ? 'active' : ''); ?>" id="transaction.listOffline"><a class="d-flex align-items-center" href="<?php echo e(route('transaction.listOffline')); ?>"><i data-feather="credit-card"></i><span class="menu-item text-truncate"><?php echo e(__('Offline Payments')); ?></span><?php ($pendingOffline = \App\Models\Transaction::where('payment_gateway', 'offline')->where('gateway_status', 'pending')->count()); ?><?php if($pendingOffline > 0): ?><span class="badge badge-light-warning rounded-pill ms-auto me-1"><?php echo e($pendingOffline); ?></span><?php endif; ?></a></li>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'module.list' ? 'active' : ''); ?>" id="module.list"><a class="d-flex align-items-center" href="<?php echo e(route('module.list')); ?>"><i data-feather="layers"></i><span class="menu-item text-truncate"><?php echo e(__('Modules')); ?></span></a></li>
                <?php if(\App\Helpers\Helpers::isEx()): ?>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'package.list' ? 'active' : ''); ?>" id="package.list"><a class="d-flex align-items-center" href="<?php echo e(route('package.list')); ?>"><i data-feather="package"></i><span class="menu-item text-truncate"><?php echo e(__('Packages')); ?></span></a></li>
                <?php endif; ?>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'setting.list' ? 'active' : ''); ?>" id="setting.list"><a class="d-flex align-items-center" href="<?php echo e(route('setting.list')); ?>"><i data-feather="settings"></i><span class="menu-item text-truncate"><?php echo e(__('Settings')); ?></span></a></li>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'device.listAll' ? 'active' : ''); ?>" id="device.listAll"><a class="d-flex align-items-center" href="<?php echo e(route('device.listAll')); ?>"><i data-feather="smartphone"></i><span class="menu-item text-truncate"><?php echo e(__('Devices')); ?>*</span><span class="badge badge-light-primary rounded-pill ms-auto me-1"><?php echo e(DB::table('devices')->count()); ?></span></a></li>
                <?php if(env('RECORD_MESSAGES')): ?>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'message.listAll' ? 'active' : ''); ?>" id="message.listAll"><a class="d-flex align-items-center" href="<?php echo e(route('message.listAll')); ?>"><i data-feather="message-square"></i><span class="menu-item text-truncate"><?php echo e(__('Messages')); ?>*</span><span class="badge badge-light-primary rounded-pill ms-auto me-1"><?php echo e(DB::table('messages')->count()); ?></span></a></li>
                <?php endif; ?>
                
                
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'user.list' ? 'active' : ''); ?>" id="user.list"><a class="d-flex align-items-center" href="<?php echo e(route('user.list')); ?>"><i data-feather="users"></i><span class="menu-item text-truncate"><?php echo e(__('Users')); ?></span><span class="badge badge-light-primary rounded-pill ms-auto me-1"><?php echo e(DB::table('users')->count()); ?></span></a></li>
                <li class="navigation-header"><span>v<?php echo e($installedVersion); ?><?php echo e((\App\Helpers\Helpers::isEx()) ? '.extended' : ''); ?></span><i data-feather="more-horizontal"></i></li>
                <?php if($installedVersion < $latestVersion): ?>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'latest.version' ? 'active' : ''); ?>" id="latest.version"><a class="d-flex align-items-center" href="<?php echo e(config('app.URL_MY_ACCOUNT')); ?>" target="_blank"><i data-feather="download-cloud"></i><span class="menu-item text-truncate"><?php echo e(__('UPDATE!')); ?></span><span class="badge badge-light-primary rounded-pill ms-auto me-1">v<?php echo e($latestVersion); ?></span></a></li>
                <?php endif; ?>
                
                <?php endif; ?>
            </ul>
            <?php endif; ?>
            <?php elseif(auth()->guard()->guest()): ?>
            <ul class="navigation navigation-main" id="main-menu-navigation" data-menu="menu-navigation">
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'user.login' ? 'active' : ''); ?>" id="user.login"><a class="d-flex align-items-center" href="<?php echo e(route('login')); ?>"><i data-feather="log-in"></i><span class="menu-title text-truncate"><?php echo e(__('Log in')); ?></span></a></li>
                <div class="dropdown-divider"></div>
                <li class="nav-item <?php echo e(isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'user.register' ? 'active' : ''); ?>" id="user.register"><a class="d-flex align-items-center" href="<?php echo e(route('register')); ?>"><i data-feather="user-plus"></i><span class="menu-item text-truncate"><?php echo e(__('Register')); ?></span></a></li>
            </ul>
            <?php endif; ?>
        </div>
    </div>
    <!-- END: Main Menu-->
<?php /**PATH /home/procharmate/public_html/whatsapp.procharmate.com/resources/views/layouts/header.blade.php ENDPATH**/ ?>