<?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/vendors/css/dropzone/dropzone.min.css">
<link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/vendors/css/tables/datatable/dataTables.bootstrap5.min.css">

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div id="jGrowl" class="jGrowl alert alert-success alert-dismissible fade show" role="alert">
        <div class="jGrowl-notification"></div>
    </div>
    <div class="content-wrapper">
        <div class="content-header row">
            <h4><?php echo e(__('Modules manager')); ?></h4>
        </div>
        <div class="content-body">
            <!-- modules list start -->
            <section class="app-module-list">
                <!-- list and filter start -->
                <div class="card">
                    <?php if(!$checkZipExtension): ?>
                        <div class="card-body">
                            <p class="text-danger font-weight-bold"><b>Zip PHP Extension</b> <?php echo e(__('Disabled')); ?>.
                            <br>
                            <?php echo e(__('Therefore, you will not be able to upload any Premium Modules')); ?>.
                            <br>
                            <span class="font-weight-normal"><?php echo e(__('Kindly contact your hosting provider to enable')); ?> <b>Zip PHP Extension</b></span>
                            </p>
                        </div>
                    <?php else: ?>
                    <div class="card-body border-bottom">
                        <div class="card-body">
                            <div class="col-md-12" id="moduleUploadBlock" style="display: block;">
                                <div class="card-body">
                                    <form method="POST" action="<?php echo e(route('module.store')); ?>" enctype="multipart/form-data"
                                        class="dropzone" id="module_uploader">
                                        <?php echo csrf_field(); ?>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                    <div class="card-body">
                        <div class="table-responsive pt-0">
                            <table id="tbl-bootstr" class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th><?php echo e(__('Name')); ?></th>
                                        <th><?php echo e(__('Description')); ?></th>
                                        <th><?php echo e(__('Status')); ?></th>
                                        <th><?php echo e(__('Version')); ?></th>
                                        <th><?php echo e(__('Actions')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $lower_name = $module->getLowerName(); ?>
                                    <tr>
                                        <td>
                                            <?php echo e($module->getName()); ?>

                                        </td>
                                        <td>
                                            <?php echo $module->getDescription(); ?>

                                        </td>
                                        <td>
                                            <?php if($module->isEnabled()): ?>
                                            <span class="badge rounded-pill badge-light-success me-1"><?php echo e(__('Enabled')); ?></span>
                                            <?php else: ?>
                                            <span class="badge rounded-pill badge-light-danger me-1"><?php echo e(__('Disabled')); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php echo config("$lower_name.version"); ?>

                                        </td>
                                        <td>
                                            <button class="btn btn-warning dropdown-toggle" type="button" id="actionButton" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i data-feather="command" class="me-0"></i>
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="actionButton">
                                            <?php if($module->isEnabled()): ?>
                                                <a class="dropdown-item" href="<?php echo e(route('module.disable', ['module_name' => $module->getName()])); ?>"><i data-feather="x-square" class="me-0"></i> <?php echo e(__('Disable')); ?></a>
                                            <?php else: ?>
                                                <a class="dropdown-item" href="<?php echo e(route('module.enable', ['module_name' => $module->getName()])); ?>"><i data-feather="check-square" class="me-0"></i> <?php echo e(__('Enable')); ?></a>
                                            <?php endif; ?>
                                                <div class="dropdown-divider"></div>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroy-<?php echo e($module->getName()); ?>"><i data-feather="trash" class="me-0"></i> <?php echo e(__('Delete')); ?></a>
                                            </div>
                                        </td>
                                    </tr>
                                    <!-- Delete Modal -->
                                    <div class="modal fade modal-danger text-start" id="destroy-<?php echo e($module->getName()); ?>" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel120"><?php echo e(__('Delete confirmation')); ?></h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <?php echo e(__('Are you sure you want to delete?')); ?> <br><br>
                                                    <span class="text text-danger"> <b><?php echo e($module->getName()); ?></b> </span><br><br>
                                                    <?php echo e(__('This process is irreversible')); ?> <br>
                                                    <?php echo e(__('The record(s) will be deleted from the database permanently')); ?>

                                                </div>
                                                <div class="modal-footer">
                                                    <a class="btn btn-sm btn-danger" href="<?php echo e(route('module.destroy', ['module_name' => $module->getName()])); ?>"><?php echo e(__('Delete')); ?></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="modal fade" id="AddNew" tabindex="-1" aria-hidden="true">
                        <div class="modal-dialog modal-lg modal-dialog-centered modal-edit-user">
                            <div class="modal-content">
                                <div class="modal-header bg-transparent">
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body pb-5 px-sm-5 pt-50">
                                    <div class="text-center mb-2">
                                        <h1 class="mb-1"><?php echo e(__('Upload new module')); ?></h1>
                                        <div class="col-md-12" id="moduleUploadBlock" style="display: block;">
                                
                                            <div class="card-body">
                                                <form method="POST" action="<?php echo e(route('module.store')); ?>" enctype="multipart/form-data"
                                                    class="dropzone" id="module_uploader">
                                                    <?php echo csrf_field(); ?>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Modal to add new module starts-->
                    <div class="modal modal-slide-in new-module-modal fade" id="addNew">
                        <div class="modal-dialog">
                            <form action="<?php echo e(route('module.store')); ?>" method="POST"  enctype="multipart/form-data" id="module_uploader" class="dropzone add-new-module modal-content pt-0">
                                <?php echo csrf_field(); ?>
                                <div>
                                    <h3><?php echo e(__('Drag-and-drop awg_ModuleName.zip file in this box')); ?></h3>
                                </div>
                            </form>
                        </div>
                    </div>
                    <!-- Modal to add new module Ends-->
                </div>
                <!-- list and filter end -->
            </section>
            <!-- modules list ends -->
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- BEGIN: Vendor JS-->
<script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/vendors.min.js"></script>
<script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/sweetalert2/sweetalert2.all.min.js"></script>
<script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/dropzone/dropzone.min.js"></script>
<script src="<?php echo e(url('/')); ?>/app-assets/js/scripts/components/components-uploader.js"></script>
<script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js"></script>
<script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/tables/datatable/dataTables.bootstrap5.min.js"></script>
<!-- BEGIN Vendor JS-->
<script>
    $(document).ready(function () {
        $('#tbl-bootstr').DataTable();
    });        
</script>

<?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home/procharmate/public_html/whatsapp.procharmate.com/resources/views//module-list.blade.php ENDPATH**/ ?>