<?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-body">
            <!-- job list start -->
            <section class="app-job-list">
                <!-- list and filter start -->
                <div class="card">
                    <h5 class="card-header">
                        <div class="input-group input-group-sm position-relative mx-auto">
                            <?php echo e(__('Subscriber list')); ?><span class="badge badge-light-secondary ms-2"><?php echo e(DB::table('subscribers')->where('user_id',Auth::user()->id)->count()); ?></span>
                            <input type="search" class="form-control" id="search" value="<?php echo e(!empty($_GET['search']) ? $_GET['search'] : ''); ?>" placeholder="<?php echo e(__('Search')); ?>..." />
                            <button type="button" class="btn btn-sm btn-primary" id="searchbtn"><i data-feather="search" class="me-0"></i></button>
                            <a class="btn btn-sm btn-success" href="<?php echo e(route('subscriber.export')); ?>"><i data-feather="external-link" class="me-0"></i> <?php echo e(strtoupper(__('Export'))); ?></a>
                        </div>
                    </h5>
                    <div class="card-body">
                        <div class="table-responsive table-responsive">
                            <table id="tbl-bootstr" class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <!-- <th> <?php echo e(__('Device')); ?> </th> -->
                                        <th> <?php echo e(__('Name')); ?> </th>
                                        <th> <?php echo e(__('Phone')); ?> </th>
                                        <th> <?php echo e(__('Subscribe')); ?> </th>
                                        <th> <?php echo e(__('Updated at')); ?> </th>
                                        <th> <?php echo e(__('Actions')); ?> </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $subscribers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subscriber): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <!-- <td><a href="javascript:;" data-bs-target="#edit-<?php echo e($subscriber->id); ?>" data-bs-toggle="modal">
                                        <?php echo e($subscriber->sender); ?></a>
                                        </td> -->
                                        <td><a href="javascript:;" data-bs-target="#edit-<?php echo e($subscriber->id); ?>" data-bs-toggle="modal">
                                        <?php echo e($subscriber->name); ?></a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-<?php echo e($subscriber->id); ?>" data-bs-toggle="modal">
                                        <?php echo e($subscriber->phone); ?></a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-<?php echo e($subscriber->id); ?>" data-bs-toggle="modal">
                                        <span class="badge rounded-pill badge-light-<?php echo e($subscriber->status?'success':'danger'); ?> me-1"><?php echo e($subscriber->status ? __('YES') : __('NO')); ?></span></a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-<?php echo e($subscriber->id); ?>" data-bs-toggle="modal">
                                        <?php echo e($subscriber->updated_at); ?></a>
                                        </td>
                                        <td>
                                            <button class="btn btn-warning dropdown-toggle" type="button" id="actionButton" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i data-feather="command" class="me-0"></i>
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="actionButton">
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#edit-<?php echo e($subscriber->id); ?>"><i data-feather="edit" class="me-0"></i> <?php echo e(__('Edit')); ?></a>
                                                <div class="dropdown-divider"></div>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroy-<?php echo e($subscriber->id); ?>"><i data-feather="trash" class="me-0"></i> <?php echo e(__('Delete')); ?></a>
                                            </div>
                                        </td>
                                    </tr>
                                    <!-- Delete Modal -->
                                    <div class="modal fade modal-danger text-start" id="destroy-<?php echo e($subscriber->id); ?>" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel120"><?php echo e(__('Delete confirmation')); ?></h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <?php echo e(__('Are you sure you want to delete?')); ?> <br><br>
                                                    <span class="text text-danger"> <b><?php echo e($subscriber->name); ?></b> </span><br><br>
                                                    <?php echo e(__('This process is irreversible')); ?> <br>
                                                    <?php echo e(__('The record(s) will be deleted from the database permanently')); ?>

                                                </div>
                                                <div class="modal-footer">
                                                <a class="btn btn-sm btn-danger" href="<?php echo e(route('subscriber.destroy', ['subscriber_id' => $subscriber->id])); ?>"><?php echo e(__('Delete')); ?></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Edit Subscriber Modal -->
                                    <div class="modal fade" id="edit-<?php echo e($subscriber->id); ?>" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-xl modal-dialog-centered modal-edit-subscriber">
                                            <div class="modal-content">
                                                <div class="modal-header bg-transparent">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body pb-5 px-sm-5 pt-50">
                                                    <div class="text-center mb-2">
                                                        <h1 class="mb-1"><?php echo e(__('Edit subscriber')); ?></h1>
                                                    </div>
                                                    <form action="<?php echo e(route('subscriber.update')); ?>" method="POST" id="editSubscriberForm" class="row gy-1 pt-75" enctype="multipart/form-data">
                                                        <?php echo csrf_field(); ?>
                                                        <div class="row">
                                                            <!-- <div class="col-12 col-md-6"> -->
                                                                <input type="hidden"  name="subscriber_id" value="<?php echo e($subscriber->id); ?>" />
                                                                <!-- <label class="form-label" for="sender"><?php echo e(__('Device')); ?></label>
                                                                <input type="text" name="sender" class="form-control" value="<?php echo e($subscriber->sender); ?>" />
                                                            </div> -->
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="name"><?php echo e(__('Name')); ?></label>
                                                                <input type="text" name="name" class="form-control" value="<?php echo e($subscriber->name); ?>" />
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="phone"><?php echo e(__('Phone')); ?></label>
                                                                <input type="text" name="phone" class="form-control" value="<?php echo e($subscriber->phone); ?>" />
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="status"><?php echo e(__('Status')); ?></label>
                                                                <select name="status" class="form-select">
                                                                    <option value="1" <?php echo e($subscriber->status ? 'selected' : ''); ?>><?php echo e(__('YES')); ?></option>
                                                                    <option value="0" <?php echo e(!$subscriber->status ? 'selected' : ''); ?>><?php echo e(__('NO')); ?></option>
                                                                </select>
                                                            </div>
                                                            <div class="col-12 text-center mt-2 pt-50">
                                                                <button type="submit" class="btn btn-primary me-1"><?php echo e(__('Save')); ?></button>
                                                                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close"><?php echo e(__('Cancel')); ?></button>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--/ Edit Subscriber Modal -->
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php echo e($subscribers->links()); ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- list and filter end -->
            </section>
            <!-- jobs list ends -->
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- BEGIN: Vendor JS-->
<script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/vendors.min.js"></script>
<!-- BEGIN Vendor JS-->
<script>
function search() {
    var url = '<?php echo e(url()->current()); ?>' + '?search=' + $('#search').val();
    location.href= url;
}
$('#searchbtn').click(function (e) {
    search();
})
$('#search').keydown(function (e) {
    if (e.which == 13) {
        search();
    }
})
</script>

<?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home/procharmate/public_html/whatsapp.procharmate.com/resources/views//subscriber-list.blade.php ENDPATH**/ ?>