<?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/vendors/css/tables/datatable/dataTables.bootstrap5.min.css">

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="card-body">
            <button type="button" class="btn btn-sm btn-primary float-end" data-bs-toggle="modal" data-bs-target="#addNew"><?php echo e(__('Add new template')); ?></button>
            
        </div>
        <div class="content-header row">
            <h4><?php echo e(__('Templates list')); ?><span class="badge rounded-pill badge-light-secondary"><?php echo e(DB::table('templates')->where('user_id',Auth::user()->id)->count()); ?></span></h4>
        </div>
        <div class="content-body">
            <!-- templates list start -->
            <section class="app-template-list">
                <!-- list and filter start -->
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive table-responsive">
                            <table id="tbl-bootstr" class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th><?php echo e(__('Template name')); ?></th>
                                        <th><?php echo e(__('Message text')); ?></th>
                                        <th><?php echo e(__('Media')); ?></th>
                                        <th><?php echo e(__('Actions')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><a href="javascript:;" data-bs-target="#edit-<?php echo e($template->id); ?>" data-bs-toggle="modal">
                                        <?php echo e($template->name); ?></a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-<?php echo e($template->id); ?>" data-bs-toggle="modal">
                                        <?php echo e(substr($template->msgtext, 0, 100) . '...'); ?></a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-<?php echo e($template->id); ?>" data-bs-toggle="modal">
                                        <?php ($arrMediaurl=explode('/', $template->mediaurl)); ?>
                                        <?php echo e(end($arrMediaurl)); ?></a>
                                        </td>
                                        <td>
                                            <button class="btn btn-warning dropdown-toggle" type="button" id="actionButton" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i data-feather="command" class="me-0"></i>
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="actionButton">
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#edit-<?php echo e($template->id); ?>"><i data-feather="edit" class="me-0"></i> <?php echo e(__('Edit')); ?></a>
                                                <div class="dropdown-divider"></div>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroy-<?php echo e($template->id); ?>"><i data-feather="trash" class="me-0"></i> <?php echo e(__('Delete')); ?></a>
                                            </div>
                                        </td>
                                    </tr>
                                    <!-- Delete Modal -->
                                    <div class="modal fade modal-danger text-start" id="destroy-<?php echo e($template->id); ?>" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel120"><?php echo e(__('Delete confirmation')); ?></h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <?php echo e(__('Are you sure you want to delete?')); ?> <br><br>
                                                    <span class="text text-danger"> <b><?php echo e($template->name); ?></b> </span><br><br>
                                                    <?php echo e(__('This process is irreversible')); ?> <br>
                                                    <?php echo e(__('The record(s) will be deleted from the database permanently')); ?>

                                                </div>
                                                <div class="modal-footer">
                                                <a class="btn btn-sm btn-danger" href="<?php echo e(route('template.destroy', ['template_id' => $template->id])); ?>"><?php echo e(__('Delete')); ?></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Edit Template Modal -->
                                    <div class="modal fade" id="edit-<?php echo e($template->id); ?>" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-xl modal-dialog-centered modal-edit-template">
                                            <div class="modal-content">
                                                <div class="modal-header bg-transparent">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body pb-5 px-sm-5 pt-50">
                                                    <div class="text-center mb-2">
                                                        <h1 class="mb-1"><?php echo e(__('Edit template')); ?></h1>
                                                    </div>
                                                    <form action="<?php echo e(route('template.update')); ?>" method="POST" id="editTemplateForm" class="row gy-1 pt-75" enctype="multipart/form-data">
                                                        <?php echo csrf_field(); ?>
                                                        <div class="row">
                                                            <div class="col-12 col-md-6">
                                                                <input type="hidden"  name="template_id" value="<?php echo e($template->id); ?>" />
                                                                <input type="hidden" name="prev_mediafile" value="<?php echo e(end($arrMediaurl)); ?>" />
                                                                <input type="hidden" name="prev_mediaurl" value="<?php echo e($template->mediaurl); ?>" />
                                                                <label class="form-label" for="name"><?php echo e(__('Template name')); ?></label>
                                                                <input type="text" name="name" class="form-control" value="<?php echo e($template->name); ?>" required />
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="mediafile"><?php echo e(__('Template mediafile')); ?></label> <label class="form-label text-warning"> (<?php echo e(__('Optional')); ?>) </label> <label class="form-label text-warning"> JPEG/PNG/GIF/PDF/DOCX/PPTX/XLSX/CSV/MP3 </label>
                                                                <input type="file" name="mediafile" class="form-control" /><?php echo e(end($arrMediaurl)); ?>

                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="msgtext"><?php echo e(__('Message text')); ?></label>
                                                                <textarea name="msgtext" class="form-control" rows="7" required><?php echo e($template->msgtext); ?></textarea>
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label> <?php echo e(__('Emoji')); ?> (<?php echo e(__('Copy and Paste')); ?>)</label>
                                                                <textarea name="emoji" class="form-control" rows="7" readonly><?php echo e(file_get_contents(public_path('app-assets/data/emoji.txt'))); ?></textarea><br>
                                                            </div>
                                                            <div class="col-12 text-center mt-2 pt-50">
                                                                <button type="submit" class="btn btn-primary me-1"><?php echo e(__('Submit')); ?></button>
                                                                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close"><?php echo e(__('Cancel')); ?></button>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--/ Edit Template Modal -->
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <!-- Modal to add new template starts-->
                        <div class="modal modal-slide-in new-template-modal fade" id="addNew">
                            <div class="modal-dialog">
                                <form action="<?php echo e(route('template.store')); ?>" method="POST" class="add-new-template modal-content pt-0" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
                                    <div class="modal-header mb-1">
                                        <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('Add new template')); ?></h5>
                                    </div>
                                    <div class="modal-body flex-grow-1">
                                        <div class="mb-1">
                                            <label class="form-label" for="name"><?php echo e(__('Template name')); ?></label>
                                            <input type="text" name="name" class="form-control" placeholder="<?php echo e(__('Template name')); ?>" required />
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="msgtext"><?php echo e(__('Message text')); ?></label>
                                            <textarea name="msgtext" class="form-control" rows="6" required></textarea>
                                        </div>
                                        <div class="mb-1">
                                            <label> <?php echo e(__('Emoji')); ?> (<?php echo e(__('Copy and Paste')); ?>)</label>
                                            <textarea name="emoji" class="form-control" rows="7" readonly><?php echo e(file_get_contents(public_path('app-assets/data/emoji.txt'))); ?></textarea><br>
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="mediafile"><?php echo e(__('Template mediafile')); ?></label> <label class="form-label text-warning"> (<?php echo e(__('Optional')); ?>) </label> <label class="form-label text-warning"> JPEG/PNG/GIF/PDF/DOCX/PPTX/XLSX/CSV/MP3 </label>
                                            <input type="file" name="mediafile" class="form-control" />
                                        </div>
                                        <button type="submit" class="btn btn-primary me-1 data-submit"><?php echo e(__('Submit')); ?></button>
                                        <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- Modal to add new template Ends-->
                    </div>
                </div>
                <!-- list and filter end -->
            </section>
            <!-- templates list ends -->
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- BEGIN: Vendor JS-->
<script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/vendors.min.js"></script>
<script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js"></script>
<script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/tables/datatable/dataTables.bootstrap5.min.js"></script>
<!-- BEGIN Vendor JS-->
<script>
    $(document).ready(function () {
        $('#tbl-bootstr').DataTable();
    });        
</script>

<?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home/procharmate/public_html/whatsapp.procharmate.com/resources/views//template-list.blade.php ENDPATH**/ ?>